/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.http.HttpResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class JsonUnmarshallerContext {
    public JsonToken currentToken;
    private JsonToken nextToken;
    private final JsonParser jsonParser;
    private final Stack<JsonFieldTokenPair> stack = new Stack();
    private String currentField;
    private String lastParsedParentElement;
    private Map<String, String> metadata = new HashMap<String, String>();
    private List<MetadataExpression> metadataExpressions = new ArrayList<MetadataExpression>();
    private final HttpResponse httpResponse;

    public JsonUnmarshallerContext(JsonParser jsonParser) {
        this(jsonParser, null);
    }

    public JsonUnmarshallerContext(JsonParser jsonParser, HttpResponse httpResponse) {
        this.jsonParser = jsonParser;
        this.httpResponse = httpResponse;
    }

    public String getHeader(String string) {
        if (this.httpResponse == null) {
            return null;
        }
        return this.httpResponse.getHeaders().get(string);
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public int getCurrentDepth() {
        int n = this.stack.size();
        if (this.currentField != null) {
            ++n;
        }
        return n;
    }

    public String readText() throws IOException {
        switch (this.currentToken) {
            case VALUE_STRING: {
                String string = this.jsonParser.getText();
                return string;
            }
            case VALUE_FALSE: {
                return "false";
            }
            case VALUE_TRUE: {
                return "true";
            }
            case VALUE_NULL: {
                return null;
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return this.jsonParser.getNumberValue().toString();
            }
            case FIELD_NAME: {
                return this.jsonParser.getText();
            }
        }
        throw new RuntimeException("We expected a VALUE token but got: " + (Object)((Object)this.currentToken));
    }

    public boolean isStartOfDocument() {
        return this.jsonParser == null || this.jsonParser.getCurrentToken() == null;
    }

    public boolean testExpression(String string) {
        if (string.equals(".")) {
            return true;
        }
        if (this.currentField != null) {
            return this.currentField.equals(string);
        }
        return !this.stack.isEmpty() && this.stack.peek().getField().equals(string);
    }

    public String getCurrentParentElement() {
        String string = this.currentField != null ? this.currentField : (!this.stack.isEmpty() ? this.stack.peek().getField() : "");
        return string;
    }

    public boolean testExpression(String string, int n) {
        if (string.equals(".")) {
            return true;
        }
        return this.testExpression(string) && n == this.getCurrentDepth();
    }

    public JsonToken nextToken() throws IOException {
        JsonToken jsonToken;
        this.currentToken = jsonToken = this.nextToken != null ? this.nextToken : this.jsonParser.nextToken();
        this.nextToken = null;
        this.updateContext();
        return jsonToken;
    }

    public JsonToken peek() throws IOException {
        if (this.nextToken != null) {
            return this.nextToken;
        }
        this.nextToken = this.jsonParser.nextToken();
        return this.nextToken;
    }

    public JsonParser getJsonParser() {
        return this.jsonParser;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void registerMetadataExpression(String string, int n, String string2) {
        this.metadataExpressions.add(new MetadataExpression(string, n, string2));
    }

    private void updateContext() throws IOException {
        this.lastParsedParentElement = null;
        if (this.currentToken == null) {
            return;
        }
        if (this.currentToken == JsonToken.START_OBJECT || this.currentToken == JsonToken.START_ARRAY) {
            if (this.currentField != null) {
                this.stack.push(new JsonFieldTokenPair(this.currentField, this.currentToken));
                this.currentField = null;
            }
        } else if (this.currentToken == JsonToken.END_OBJECT || this.currentToken == JsonToken.END_ARRAY) {
            if (!this.stack.isEmpty()) {
                boolean bl;
                boolean bl2 = this.currentToken == JsonToken.END_ARRAY && this.stack.peek().getToken() == JsonToken.START_ARRAY;
                boolean bl3 = bl = this.currentToken == JsonToken.END_OBJECT && this.stack.peek().getToken() == JsonToken.START_OBJECT;
                if (bl2 || bl) {
                    this.lastParsedParentElement = this.stack.pop().getField();
                }
            }
            this.currentField = null;
        } else if (this.currentToken == JsonToken.FIELD_NAME) {
            String string;
            this.currentField = string = this.jsonParser.getText();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (JsonFieldTokenPair jsonFieldTokenPair : this.stack) {
            stringBuilder.append("/").append(jsonFieldTokenPair.getField());
        }
        if (this.currentField != null) {
            stringBuilder.append("/").append(this.currentField);
        }
        return stringBuilder.length() == 0 ? "/" : stringBuilder.toString();
    }

    public String getLastParsedParentElement() {
        return this.lastParsedParentElement;
    }

    private static class JsonFieldTokenPair {
        private final String field;
        private final JsonToken jsonToken;

        public JsonFieldTokenPair(String string, JsonToken jsonToken) {
            this.field = string;
            this.jsonToken = jsonToken;
        }

        public String getField() {
            return this.field;
        }

        public JsonToken getToken() {
            return this.jsonToken;
        }

        public String toString() {
            return this.field + ": " + this.jsonToken.asString();
        }
    }

    private static class MetadataExpression {
        public String expression;
        public int targetDepth;
        public String key;

        public MetadataExpression(String string, int n, String string2) {
            this.expression = string;
            this.targetDepth = n;
            this.key = string2;
        }
    }
}

