/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.internal.MetricAware;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;

public class SdkDigestInputStream
extends DigestInputStream
implements MetricAware {
    private static final int SKIP_BUF_SIZE = 2048;

    public SdkDigestInputStream(InputStream inputStream, MessageDigest messageDigest) {
        super(inputStream, messageDigest);
    }

    @Override
    public final boolean isMetricActivated() {
        if (this.in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)this.in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    @Override
    public final long skip(long l) throws IOException {
        long l2;
        int n;
        if (l <= 0L) {
            return l;
        }
        byte[] byArray = new byte[(int)Math.min(2048L, l)];
        for (l2 = l; l2 > 0L; l2 -= (long)n) {
            n = this.read(byArray, 0, (int)Math.min(l2, (long)byArray.length));
            if (n != -1) continue;
            return l2 == l ? -1L : l - l2;
        }
        assert (l2 == 0L);
        return l;
    }
}

