/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.Protocol;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.util.VersionInfoUtils;
import java.net.InetAddress;

public class ClientConfiguration {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 50000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 50000;
    public static final int DEFAULT_MAX_CONNECTIONS = 50;
    public static final String DEFAULT_USER_AGENT = VersionInfoUtils.getUserAgent();
    public static final RetryPolicy DEFAULT_RETRY_POLICY = PredefinedRetryPolicies.DEFAULT;
    public static final boolean DEFAULT_USE_REAPER = true;
    private String userAgent = DEFAULT_USER_AGENT;
    private int maxErrorRetry = -1;
    private RetryPolicy retryPolicy = DEFAULT_RETRY_POLICY;
    private InetAddress localAddress;
    private Protocol protocol = Protocol.HTTPS;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String proxyDomain = null;
    private String proxyWorkstation = null;
    private boolean preemptiveBasicProxyAuth;
    private int maxConnections = 50;
    private int socketTimeout = 50000;
    private int connectionTimeout = 50000;
    private int socketSendBufferSizeHint = 0;
    private int socketReceiveBufferSizeHint = 0;
    private boolean useReaper = true;
    private String signerOverride;

    public ClientConfiguration() {
    }

    public ClientConfiguration(ClientConfiguration clientConfiguration) {
        this.connectionTimeout = clientConfiguration.connectionTimeout;
        this.maxConnections = clientConfiguration.maxConnections;
        this.maxErrorRetry = clientConfiguration.maxErrorRetry;
        this.retryPolicy = clientConfiguration.retryPolicy;
        this.localAddress = clientConfiguration.localAddress;
        this.protocol = clientConfiguration.protocol;
        this.proxyDomain = clientConfiguration.proxyDomain;
        this.proxyHost = clientConfiguration.proxyHost;
        this.proxyPassword = clientConfiguration.proxyPassword;
        this.proxyPort = clientConfiguration.proxyPort;
        this.proxyUsername = clientConfiguration.proxyUsername;
        this.proxyWorkstation = clientConfiguration.proxyWorkstation;
        this.preemptiveBasicProxyAuth = clientConfiguration.preemptiveBasicProxyAuth;
        this.socketTimeout = clientConfiguration.socketTimeout;
        this.userAgent = clientConfiguration.userAgent;
        this.useReaper = clientConfiguration.useReaper;
        this.socketReceiveBufferSizeHint = clientConfiguration.socketReceiveBufferSizeHint;
        this.socketSendBufferSizeHint = clientConfiguration.socketSendBufferSizeHint;
        this.signerOverride = clientConfiguration.signerOverride;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public ClientConfiguration withProtocol(Protocol protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    public ClientConfiguration withMaxConnections(int n) {
        this.setMaxConnections(n);
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public ClientConfiguration withUserAgent(String string) {
        this.setUserAgent(string);
        return this;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
    }

    public ClientConfiguration withLocalAddress(InetAddress inetAddress) {
        this.setLocalAddress(inetAddress);
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String string) {
        this.proxyHost = string;
    }

    public ClientConfiguration withProxyHost(String string) {
        this.setProxyHost(string);
        return this;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
    }

    public ClientConfiguration withProxyPort(int n) {
        this.setProxyPort(n);
        return this;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String string) {
        this.proxyUsername = string;
    }

    public ClientConfiguration withProxyUsername(String string) {
        this.setProxyUsername(string);
        return this;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
    }

    public ClientConfiguration withProxyPassword(String string) {
        this.setProxyPassword(string);
        return this;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String string) {
        this.proxyDomain = string;
    }

    public ClientConfiguration withProxyDomain(String string) {
        this.setProxyDomain(string);
        return this;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setProxyWorkstation(String string) {
        this.proxyWorkstation = string;
    }

    public ClientConfiguration withProxyWorkstation(String string) {
        this.setProxyWorkstation(string);
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public ClientConfiguration withRetryPolicy(RetryPolicy retryPolicy) {
        this.setRetryPolicy(retryPolicy);
        return this;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public void setMaxErrorRetry(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maxErrorRetry shoud be non-negative");
        }
        this.maxErrorRetry = n;
    }

    public ClientConfiguration withMaxErrorRetry(int n) {
        this.setMaxErrorRetry(n);
        return this;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int n) {
        this.socketTimeout = n;
    }

    public ClientConfiguration withSocketTimeout(int n) {
        this.setSocketTimeout(n);
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public ClientConfiguration withConnectionTimeout(int n) {
        this.setConnectionTimeout(n);
        return this;
    }

    public boolean useReaper() {
        return this.useReaper;
    }

    public void setUseReaper(boolean bl) {
        this.useReaper = bl;
    }

    public ClientConfiguration withReaper(boolean bl) {
        this.setUseReaper(bl);
        return this;
    }

    public int[] getSocketBufferSizeHints() {
        return new int[]{this.socketSendBufferSizeHint, this.socketReceiveBufferSizeHint};
    }

    public void setSocketBufferSizeHints(int n, int n2) {
        this.socketSendBufferSizeHint = n;
        this.socketReceiveBufferSizeHint = n2;
    }

    public ClientConfiguration withSocketBufferSizeHints(int n, int n2) {
        this.setSocketBufferSizeHints(n, n2);
        return this;
    }

    public String getSignerOverride() {
        return this.signerOverride;
    }

    public void setSignerOverride(String string) {
        this.signerOverride = string;
    }

    public ClientConfiguration withSignerOverride(String string) {
        this.setSignerOverride(string);
        return this;
    }

    public boolean isPreemptiveBasicProxyAuth() {
        return this.preemptiveBasicProxyAuth;
    }

    public void setPreemptiveBasicProxyAuth(Boolean bl) {
        this.preemptiveBasicProxyAuth = bl;
    }

    public ClientConfiguration withPreemptiveBasicProxyAuth(boolean bl) {
        this.setPreemptiveBasicProxyAuth(bl);
        return this;
    }
}

