/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.AmazonClientException;
import com.amazonaws.util.json.AwsJsonFactory;
import com.amazonaws.util.json.AwsJsonReader;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.GsonFactory;
import com.amazonaws.util.json.JacksonFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JsonUtils {
    private static volatile AwsJsonFactory factory = new GsonFactory();

    public static void setJsonEngine(JsonEngine jsonEngine) {
        switch (jsonEngine) {
            case Gson: {
                factory = new GsonFactory();
                break;
            }
            case Jackson: {
                factory = new JacksonFactory();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported json engine");
            }
        }
    }

    public static void setJsonEngine(AwsJsonFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory can't be null");
        }
        JsonUtils.factory = factory;
    }

    public static AwsJsonReader getJsonReader(Reader in) {
        if (factory == null) {
            throw new IllegalStateException("Json engine is unavailable.");
        }
        return factory.getJsonReader(in);
    }

    public static AwsJsonWriter getJsonWriter(Writer out) {
        if (factory == null) {
            throw new IllegalStateException("Json engine is unavailable.");
        }
        return factory.getJsonWriter(out);
    }

    public static Map<String, String> jsonToMap(Reader in) {
        AwsJsonReader reader = JsonUtils.getJsonReader(in);
        try {
            if (reader.peek() == null) {
                return Collections.EMPTY_MAP;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (reader.isContainer()) {
                    reader.skipValue();
                    continue;
                }
                map.put(key, reader.nextString());
            }
            reader.endObject();
            reader.close();
            return Collections.unmodifiableMap(map);
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to parse Json String.", e);
        }
    }

    public static Map<String, String> jsonToMap(String json) {
        return JsonUtils.jsonToMap(new StringReader(json));
    }

    public static String mapToString(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "{}";
        }
        try {
            StringWriter out = new StringWriter();
            AwsJsonWriter writer = JsonUtils.getJsonWriter(out);
            writer.beginObject();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                writer.name(entry.getKey()).value(entry.getValue());
            }
            writer.endObject();
            writer.close();
            return out.toString();
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to serialize to Json String.", e);
        }
    }

    private static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static enum JsonEngine {
        Gson,
        Jackson;

    }
}

