/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.com.google.gson.stream.JsonReader;
import com.amazonaws.com.google.gson.stream.JsonToken;
import com.amazonaws.com.google.gson.stream.JsonWriter;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.json.AwsJsonFactory;
import com.amazonaws.util.json.AwsJsonReader;
import com.amazonaws.util.json.AwsJsonToken;
import com.amazonaws.util.json.AwsJsonWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Date;

final class GsonFactory
implements AwsJsonFactory {
    GsonFactory() {
    }

    @Override
    public AwsJsonReader getJsonReader(Reader in) {
        return new GsonReader(in);
    }

    @Override
    public AwsJsonWriter getJsonWriter(Writer out) {
        return new GsonWriter(out);
    }

    private static AwsJsonToken convert(JsonToken token) {
        if (token == null) {
            return null;
        }
        switch (token) {
            case BEGIN_ARRAY: {
                return AwsJsonToken.BEGIN_ARRAY;
            }
            case END_ARRAY: {
                return AwsJsonToken.END_ARRAY;
            }
            case BEGIN_OBJECT: {
                return AwsJsonToken.BEGIN_OBJECT;
            }
            case END_OBJECT: {
                return AwsJsonToken.END_OBJECT;
            }
            case NAME: {
                return AwsJsonToken.FIELD_NAME;
            }
            case BOOLEAN: {
                return AwsJsonToken.VALUE_BOOLEAN;
            }
            case NUMBER: {
                return AwsJsonToken.VALUE_NUMBER;
            }
            case NULL: {
                return AwsJsonToken.VALUE_NULL;
            }
            case STRING: {
                return AwsJsonToken.VALUE_STRING;
            }
            case END_DOCUMENT: {
                return null;
            }
        }
        return AwsJsonToken.UNKNOWN;
    }

    private static final class GsonWriter
    implements AwsJsonWriter {
        private final JsonWriter writer;

        public GsonWriter(Writer out) {
            this.writer = new JsonWriter(out);
        }

        @Override
        public AwsJsonWriter beginArray() throws IOException {
            this.writer.beginArray();
            return this;
        }

        @Override
        public AwsJsonWriter endArray() throws IOException {
            this.writer.endArray();
            return this;
        }

        @Override
        public AwsJsonWriter beginObject() throws IOException {
            this.writer.beginObject();
            return this;
        }

        @Override
        public AwsJsonWriter endObject() throws IOException {
            this.writer.endObject();
            return this;
        }

        @Override
        public AwsJsonWriter name(String name) throws IOException {
            this.writer.name(name);
            return this;
        }

        @Override
        public AwsJsonWriter value(String value) throws IOException {
            this.writer.value(value);
            return this;
        }

        @Override
        public AwsJsonWriter value(boolean value) throws IOException {
            this.writer.value(value);
            return this;
        }

        @Override
        public AwsJsonWriter value(double value) throws IOException {
            this.writer.value(value);
            return this;
        }

        @Override
        public AwsJsonWriter value(long value) throws IOException {
            this.writer.value(value);
            return this;
        }

        @Override
        public AwsJsonWriter value(Number value) throws IOException {
            this.writer.value(value);
            return this;
        }

        @Override
        public AwsJsonWriter value(Date value) throws IOException {
            BigDecimal dateValue = BigDecimal.valueOf(value.getTime());
            this.writer.value(dateValue.scaleByPowerOfTen(-3));
            return this;
        }

        @Override
        public AwsJsonWriter value(ByteBuffer value) throws IOException {
            value.mark();
            byte[] bytes = new byte[value.remaining()];
            value.get(bytes, 0, bytes.length);
            value.reset();
            this.writer.value(BinaryUtils.toBase64(bytes));
            return this;
        }

        @Override
        public AwsJsonWriter value() throws IOException {
            this.writer.nullValue();
            return this;
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static final class GsonReader
    implements AwsJsonReader {
        private final JsonReader reader;

        public GsonReader(Reader in) {
            this.reader = new JsonReader(in);
        }

        @Override
        public void beginArray() throws IOException {
            this.reader.beginArray();
        }

        @Override
        public void endArray() throws IOException {
            this.reader.endArray();
        }

        @Override
        public void beginObject() throws IOException {
            this.reader.beginObject();
        }

        @Override
        public void endObject() throws IOException {
            this.reader.endObject();
        }

        @Override
        public boolean isContainer() throws IOException {
            JsonToken token = this.reader.peek();
            return JsonToken.BEGIN_ARRAY.equals((Object)token) || JsonToken.BEGIN_OBJECT.equals((Object)token);
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.reader.hasNext();
        }

        @Override
        public String nextName() throws IOException {
            return this.reader.nextName();
        }

        @Override
        public String nextString() throws IOException {
            JsonToken token = this.reader.peek();
            if (JsonToken.NULL.equals((Object)token)) {
                this.reader.nextNull();
                return null;
            }
            if (JsonToken.BOOLEAN.equals((Object)token)) {
                return this.reader.nextBoolean() ? "true" : "false";
            }
            return this.reader.nextString();
        }

        @Override
        public void skipValue() throws IOException {
            this.reader.skipValue();
        }

        @Override
        public AwsJsonToken peek() throws IOException {
            try {
                return GsonFactory.convert(this.reader.peek());
            }
            catch (EOFException e) {
                return null;
            }
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

