/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentity.model.UpdateIdentityPoolRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.StringWriter;
import java.util.Map;

public class UpdateIdentityPoolRequestMarshaller
implements Marshaller<Request<UpdateIdentityPoolRequest>, UpdateIdentityPoolRequest> {
    @Override
    public Request<UpdateIdentityPoolRequest> marshall(UpdateIdentityPoolRequest updateIdentityPoolRequest) {
        if (updateIdentityPoolRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateIdentityPoolRequest> request = new DefaultRequest<UpdateIdentityPoolRequest>(updateIdentityPoolRequest, "AmazonCognitoIdentity");
        String target = "AWSCognitoIdentityService.UpdateIdentityPool";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag openIdConnectProviderARNsList;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter(stringWriter);
            jsonWriter.beginObject();
            if (updateIdentityPoolRequest.getIdentityPoolId() != null) {
                jsonWriter.name("IdentityPoolId").value(updateIdentityPoolRequest.getIdentityPoolId());
            }
            if (updateIdentityPoolRequest.getIdentityPoolName() != null) {
                jsonWriter.name("IdentityPoolName").value(updateIdentityPoolRequest.getIdentityPoolName());
            }
            if (updateIdentityPoolRequest.isAllowUnauthenticatedIdentities() != null) {
                jsonWriter.name("AllowUnauthenticatedIdentities").value(updateIdentityPoolRequest.isAllowUnauthenticatedIdentities());
            }
            if (updateIdentityPoolRequest.getSupportedLoginProviders() != null) {
                jsonWriter.name("SupportedLoginProviders");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> supportedLoginProvidersListValue : updateIdentityPoolRequest.getSupportedLoginProviders().entrySet()) {
                    if (supportedLoginProvidersListValue.getValue() == null) continue;
                    jsonWriter.name(supportedLoginProvidersListValue.getKey());
                    jsonWriter.value(supportedLoginProvidersListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (updateIdentityPoolRequest.getDeveloperProviderName() != null) {
                jsonWriter.name("DeveloperProviderName").value(updateIdentityPoolRequest.getDeveloperProviderName());
            }
            if (!((openIdConnectProviderARNsList = (ListWithAutoConstructFlag)updateIdentityPoolRequest.getOpenIdConnectProviderARNs()) == null || openIdConnectProviderARNsList.isAutoConstruct() && openIdConnectProviderARNsList.isEmpty())) {
                jsonWriter.name("OpenIdConnectProviderARNs");
                jsonWriter.beginArray();
                for (String openIdConnectProviderARNsListValue : openIdConnectProviderARNsList) {
                    if (openIdConnectProviderARNsListValue == null) continue;
                    jsonWriter.value(openIdConnectProviderARNsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

