/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.json.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;

public class JsonErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final String X_AMZN_ERROR_TYPE = "x-amzn-ErrorType";
    private final List<? extends JsonErrorUnmarshaller> unmarshallerList;

    public JsonErrorResponseHandler(List<? extends JsonErrorUnmarshaller> exceptionUnmarshallers) {
        this.unmarshallerList = exceptionUnmarshallers;
    }

    @Override
    public AmazonServiceException handle(HttpResponse response) throws Exception {
        JsonErrorResponse error;
        try {
            error = JsonErrorResponse.fromResponse(response);
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to parse error response", e);
        }
        AmazonServiceException ase = this.runErrorUnmarshallers(error);
        if (ase == null) {
            return null;
        }
        ase.setServiceName(response.getRequest().getServiceName());
        ase.setStatusCode(response.getStatusCode());
        if (response.getStatusCode() < 500) {
            ase.setErrorType(AmazonServiceException.ErrorType.Client);
        } else {
            ase.setErrorType(AmazonServiceException.ErrorType.Service);
        }
        ase.setErrorCode(error.getErrorCode());
        for (Map.Entry<String, String> headerEntry : response.getHeaders().entrySet()) {
            if (!headerEntry.getKey().equalsIgnoreCase("X-Amzn-RequestId")) continue;
            ase.setRequestId(headerEntry.getValue());
        }
        return ase;
    }

    private AmazonServiceException runErrorUnmarshallers(JsonErrorResponse error) throws Exception {
        for (JsonErrorUnmarshaller jsonErrorUnmarshaller : this.unmarshallerList) {
            if (!jsonErrorUnmarshaller.match(error)) continue;
            return jsonErrorUnmarshaller.unmarshall(error);
        }
        return null;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    public static class JsonErrorResponse {
        private final int statusCode;
        private final String message;
        private final String errorCode;
        private final Map<String, String> map;

        private JsonErrorResponse(int statusCode, String errorCode, Map<String, String> map) {
            this.statusCode = statusCode;
            this.errorCode = errorCode;
            this.map = map;
            this.message = this.get("message");
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public String get(String key) {
            if (key == null || key.length() == 0) {
                return null;
            }
            String firstLetterLowercaseKey = key.substring(0, 1).toLowerCase() + key.substring(1);
            String firstLetterUppercaseKey = key.substring(0, 1).toUpperCase() + key.substring(1);
            String value = "";
            if (this.map.containsKey(firstLetterUppercaseKey)) {
                value = this.map.get(firstLetterUppercaseKey);
            } else if (this.map.containsKey(firstLetterLowercaseKey)) {
                value = this.map.get(firstLetterLowercaseKey);
            }
            return value;
        }

        public static JsonErrorResponse fromResponse(HttpResponse response) throws IOException {
            int statusCode = response.getStatusCode();
            Map<String, String> map = JsonUtils.jsonToMap(new BufferedReader(new InputStreamReader(response.getContent())));
            String errorCode = response.getHeaders().get(JsonErrorResponseHandler.X_AMZN_ERROR_TYPE);
            if (errorCode != null) {
                int separator = errorCode.indexOf(58);
                if (separator != -1) {
                    errorCode = errorCode.substring(0, separator);
                }
            } else if (map.containsKey("__type")) {
                String type = map.get("__type");
                int separator = type.lastIndexOf("#");
                errorCode = type.substring(separator + 1);
            }
            return new JsonErrorResponse(statusCode, errorCode, map);
        }
    }
}

