/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.MessageActionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdminCreateUserRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String userPoolId;
    private String username;
    private List<AttributeType> userAttributes;
    private List<AttributeType> validationData;
    private String temporaryPassword;
    private Boolean forceAliasCreation;
    private String messageAction;
    private List<String> desiredDeliveryMediums;
    private Map<String, String> clientMetadata;

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public AdminCreateUserRequest withUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public AdminCreateUserRequest withUsername(String username) {
        this.username = username;
        return this;
    }

    public List<AttributeType> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(Collection<AttributeType> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
            return;
        }
        this.userAttributes = new ArrayList<AttributeType>(userAttributes);
    }

    public AdminCreateUserRequest withUserAttributes(AttributeType ... userAttributes) {
        if (this.getUserAttributes() == null) {
            this.userAttributes = new ArrayList<AttributeType>(userAttributes.length);
        }
        for (AttributeType value : userAttributes) {
            this.userAttributes.add(value);
        }
        return this;
    }

    public AdminCreateUserRequest withUserAttributes(Collection<AttributeType> userAttributes) {
        this.setUserAttributes(userAttributes);
        return this;
    }

    public List<AttributeType> getValidationData() {
        return this.validationData;
    }

    public void setValidationData(Collection<AttributeType> validationData) {
        if (validationData == null) {
            this.validationData = null;
            return;
        }
        this.validationData = new ArrayList<AttributeType>(validationData);
    }

    public AdminCreateUserRequest withValidationData(AttributeType ... validationData) {
        if (this.getValidationData() == null) {
            this.validationData = new ArrayList<AttributeType>(validationData.length);
        }
        for (AttributeType value : validationData) {
            this.validationData.add(value);
        }
        return this;
    }

    public AdminCreateUserRequest withValidationData(Collection<AttributeType> validationData) {
        this.setValidationData(validationData);
        return this;
    }

    public String getTemporaryPassword() {
        return this.temporaryPassword;
    }

    public void setTemporaryPassword(String temporaryPassword) {
        this.temporaryPassword = temporaryPassword;
    }

    public AdminCreateUserRequest withTemporaryPassword(String temporaryPassword) {
        this.temporaryPassword = temporaryPassword;
        return this;
    }

    public Boolean isForceAliasCreation() {
        return this.forceAliasCreation;
    }

    public Boolean getForceAliasCreation() {
        return this.forceAliasCreation;
    }

    public void setForceAliasCreation(Boolean forceAliasCreation) {
        this.forceAliasCreation = forceAliasCreation;
    }

    public AdminCreateUserRequest withForceAliasCreation(Boolean forceAliasCreation) {
        this.forceAliasCreation = forceAliasCreation;
        return this;
    }

    public String getMessageAction() {
        return this.messageAction;
    }

    public void setMessageAction(String messageAction) {
        this.messageAction = messageAction;
    }

    public AdminCreateUserRequest withMessageAction(String messageAction) {
        this.messageAction = messageAction;
        return this;
    }

    public void setMessageAction(MessageActionType messageAction) {
        this.messageAction = messageAction.toString();
    }

    public AdminCreateUserRequest withMessageAction(MessageActionType messageAction) {
        this.messageAction = messageAction.toString();
        return this;
    }

    public List<String> getDesiredDeliveryMediums() {
        return this.desiredDeliveryMediums;
    }

    public void setDesiredDeliveryMediums(Collection<String> desiredDeliveryMediums) {
        if (desiredDeliveryMediums == null) {
            this.desiredDeliveryMediums = null;
            return;
        }
        this.desiredDeliveryMediums = new ArrayList<String>(desiredDeliveryMediums);
    }

    public AdminCreateUserRequest withDesiredDeliveryMediums(String ... desiredDeliveryMediums) {
        if (this.getDesiredDeliveryMediums() == null) {
            this.desiredDeliveryMediums = new ArrayList<String>(desiredDeliveryMediums.length);
        }
        for (String value : desiredDeliveryMediums) {
            this.desiredDeliveryMediums.add(value);
        }
        return this;
    }

    public AdminCreateUserRequest withDesiredDeliveryMediums(Collection<String> desiredDeliveryMediums) {
        this.setDesiredDeliveryMediums(desiredDeliveryMediums);
        return this;
    }

    public Map<String, String> getClientMetadata() {
        return this.clientMetadata;
    }

    public void setClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
    }

    public AdminCreateUserRequest withClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
        return this;
    }

    public AdminCreateUserRequest addClientMetadataEntry(String key, String value) {
        if (null == this.clientMetadata) {
            this.clientMetadata = new HashMap<String, String>();
        }
        if (this.clientMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.clientMetadata.put(key, value);
        return this;
    }

    public AdminCreateUserRequest clearClientMetadataEntries() {
        this.clientMetadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolId() != null) {
            sb.append("UserPoolId: " + this.getUserPoolId() + ",");
        }
        if (this.getUsername() != null) {
            sb.append("Username: " + this.getUsername() + ",");
        }
        if (this.getUserAttributes() != null) {
            sb.append("UserAttributes: " + this.getUserAttributes() + ",");
        }
        if (this.getValidationData() != null) {
            sb.append("ValidationData: " + this.getValidationData() + ",");
        }
        if (this.getTemporaryPassword() != null) {
            sb.append("TemporaryPassword: " + this.getTemporaryPassword() + ",");
        }
        if (this.getForceAliasCreation() != null) {
            sb.append("ForceAliasCreation: " + this.getForceAliasCreation() + ",");
        }
        if (this.getMessageAction() != null) {
            sb.append("MessageAction: " + this.getMessageAction() + ",");
        }
        if (this.getDesiredDeliveryMediums() != null) {
            sb.append("DesiredDeliveryMediums: " + this.getDesiredDeliveryMediums() + ",");
        }
        if (this.getClientMetadata() != null) {
            sb.append("ClientMetadata: " + this.getClientMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolId() == null ? 0 : this.getUserPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttributes() == null ? 0 : this.getUserAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getValidationData() == null ? 0 : this.getValidationData().hashCode());
        hashCode = 31 * hashCode + (this.getTemporaryPassword() == null ? 0 : this.getTemporaryPassword().hashCode());
        hashCode = 31 * hashCode + (this.getForceAliasCreation() == null ? 0 : this.getForceAliasCreation().hashCode());
        hashCode = 31 * hashCode + (this.getMessageAction() == null ? 0 : this.getMessageAction().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredDeliveryMediums() == null ? 0 : this.getDesiredDeliveryMediums().hashCode());
        hashCode = 31 * hashCode + (this.getClientMetadata() == null ? 0 : this.getClientMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminCreateUserRequest)) {
            return false;
        }
        AdminCreateUserRequest other = (AdminCreateUserRequest)obj;
        if (other.getUserPoolId() == null ^ this.getUserPoolId() == null) {
            return false;
        }
        if (other.getUserPoolId() != null && !other.getUserPoolId().equals(this.getUserPoolId())) {
            return false;
        }
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getUserAttributes() == null ^ this.getUserAttributes() == null) {
            return false;
        }
        if (other.getUserAttributes() != null && !other.getUserAttributes().equals(this.getUserAttributes())) {
            return false;
        }
        if (other.getValidationData() == null ^ this.getValidationData() == null) {
            return false;
        }
        if (other.getValidationData() != null && !other.getValidationData().equals(this.getValidationData())) {
            return false;
        }
        if (other.getTemporaryPassword() == null ^ this.getTemporaryPassword() == null) {
            return false;
        }
        if (other.getTemporaryPassword() != null && !other.getTemporaryPassword().equals(this.getTemporaryPassword())) {
            return false;
        }
        if (other.getForceAliasCreation() == null ^ this.getForceAliasCreation() == null) {
            return false;
        }
        if (other.getForceAliasCreation() != null && !other.getForceAliasCreation().equals(this.getForceAliasCreation())) {
            return false;
        }
        if (other.getMessageAction() == null ^ this.getMessageAction() == null) {
            return false;
        }
        if (other.getMessageAction() != null && !other.getMessageAction().equals(this.getMessageAction())) {
            return false;
        }
        if (other.getDesiredDeliveryMediums() == null ^ this.getDesiredDeliveryMediums() == null) {
            return false;
        }
        if (other.getDesiredDeliveryMediums() != null && !other.getDesiredDeliveryMediums().equals(this.getDesiredDeliveryMediums())) {
            return false;
        }
        if (other.getClientMetadata() == null ^ this.getClientMetadata() == null) {
            return false;
        }
        return other.getClientMetadata() == null || other.getClientMetadata().equals(this.getClientMetadata());
    }
}

