/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.ResourceServerScopeType;
import com.amazonaws.services.cognitoidentityprovider.model.ResourceServerType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.ResourceServerScopeTypeJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.List;

class ResourceServerTypeJsonMarshaller {
    private static ResourceServerTypeJsonMarshaller instance;

    ResourceServerTypeJsonMarshaller() {
    }

    public void marshall(ResourceServerType resourceServerType, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (resourceServerType.getUserPoolId() != null) {
            String userPoolId = resourceServerType.getUserPoolId();
            jsonWriter.name("UserPoolId");
            jsonWriter.value(userPoolId);
        }
        if (resourceServerType.getIdentifier() != null) {
            String identifier = resourceServerType.getIdentifier();
            jsonWriter.name("Identifier");
            jsonWriter.value(identifier);
        }
        if (resourceServerType.getName() != null) {
            String name = resourceServerType.getName();
            jsonWriter.name("Name");
            jsonWriter.value(name);
        }
        if (resourceServerType.getScopes() != null) {
            List<ResourceServerScopeType> scopes = resourceServerType.getScopes();
            jsonWriter.name("Scopes");
            jsonWriter.beginArray();
            for (ResourceServerScopeType scopesItem : scopes) {
                if (scopesItem == null) continue;
                ResourceServerScopeTypeJsonMarshaller.getInstance().marshall(scopesItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    public static ResourceServerTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceServerTypeJsonMarshaller();
        }
        return instance;
    }
}

