/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.LogConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.CloudWatchLogsConfigurationTypeJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class LogConfigurationTypeJsonUnmarshaller
implements Unmarshaller<LogConfigurationType, JsonUnmarshallerContext> {
    private static LogConfigurationTypeJsonUnmarshaller instance;

    LogConfigurationTypeJsonUnmarshaller() {
    }

    public LogConfigurationType unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        LogConfigurationType logConfigurationType = new LogConfigurationType();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("LogLevel")) {
                logConfigurationType.setLogLevel(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("EventSource")) {
                logConfigurationType.setEventSource(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("CloudWatchLogsConfiguration")) {
                logConfigurationType.setCloudWatchLogsConfiguration(CloudWatchLogsConfigurationTypeJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return logConfigurationType;
    }

    public static LogConfigurationTypeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LogConfigurationTypeJsonUnmarshaller();
        }
        return instance;
    }
}

