/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AnalyticsConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.CreateUserPoolClientRequest;
import com.amazonaws.services.cognitoidentityprovider.model.TokenValidityUnitsType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AnalyticsConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.TokenValidityUnitsTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateUserPoolClientRequestMarshaller
implements Marshaller<Request<CreateUserPoolClientRequest>, CreateUserPoolClientRequest> {
    public Request<CreateUserPoolClientRequest> marshall(CreateUserPoolClientRequest createUserPoolClientRequest) {
        if (createUserPoolClientRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateUserPoolClientRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createUserPoolClientRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.CreateUserPoolClient";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (createUserPoolClientRequest.getUserPoolId() != null) {
                String userPoolId = createUserPoolClientRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (createUserPoolClientRequest.getClientName() != null) {
                String clientName = createUserPoolClientRequest.getClientName();
                jsonWriter.name("ClientName");
                jsonWriter.value(clientName);
            }
            if (createUserPoolClientRequest.getGenerateSecret() != null) {
                Boolean generateSecret = createUserPoolClientRequest.getGenerateSecret();
                jsonWriter.name("GenerateSecret");
                jsonWriter.value(generateSecret.booleanValue());
            }
            if (createUserPoolClientRequest.getRefreshTokenValidity() != null) {
                Integer refreshTokenValidity = createUserPoolClientRequest.getRefreshTokenValidity();
                jsonWriter.name("RefreshTokenValidity");
                jsonWriter.value((Number)refreshTokenValidity);
            }
            if (createUserPoolClientRequest.getAccessTokenValidity() != null) {
                Integer accessTokenValidity = createUserPoolClientRequest.getAccessTokenValidity();
                jsonWriter.name("AccessTokenValidity");
                jsonWriter.value((Number)accessTokenValidity);
            }
            if (createUserPoolClientRequest.getIdTokenValidity() != null) {
                Integer idTokenValidity = createUserPoolClientRequest.getIdTokenValidity();
                jsonWriter.name("IdTokenValidity");
                jsonWriter.value((Number)idTokenValidity);
            }
            if (createUserPoolClientRequest.getTokenValidityUnits() != null) {
                TokenValidityUnitsType tokenValidityUnits = createUserPoolClientRequest.getTokenValidityUnits();
                jsonWriter.name("TokenValidityUnits");
                TokenValidityUnitsTypeJsonMarshaller.getInstance().marshall(tokenValidityUnits, jsonWriter);
            }
            if (createUserPoolClientRequest.getReadAttributes() != null) {
                List<String> readAttributes = createUserPoolClientRequest.getReadAttributes();
                jsonWriter.name("ReadAttributes");
                jsonWriter.beginArray();
                for (String readAttributesItem : readAttributes) {
                    if (readAttributesItem == null) continue;
                    jsonWriter.value(readAttributesItem);
                }
                jsonWriter.endArray();
            }
            if (createUserPoolClientRequest.getWriteAttributes() != null) {
                List<String> writeAttributes = createUserPoolClientRequest.getWriteAttributes();
                jsonWriter.name("WriteAttributes");
                jsonWriter.beginArray();
                for (String writeAttributesItem : writeAttributes) {
                    if (writeAttributesItem == null) continue;
                    jsonWriter.value(writeAttributesItem);
                }
                jsonWriter.endArray();
            }
            if (createUserPoolClientRequest.getExplicitAuthFlows() != null) {
                List<String> explicitAuthFlows = createUserPoolClientRequest.getExplicitAuthFlows();
                jsonWriter.name("ExplicitAuthFlows");
                jsonWriter.beginArray();
                for (String explicitAuthFlowsItem : explicitAuthFlows) {
                    if (explicitAuthFlowsItem == null) continue;
                    jsonWriter.value(explicitAuthFlowsItem);
                }
                jsonWriter.endArray();
            }
            if (createUserPoolClientRequest.getSupportedIdentityProviders() != null) {
                List<String> supportedIdentityProviders = createUserPoolClientRequest.getSupportedIdentityProviders();
                jsonWriter.name("SupportedIdentityProviders");
                jsonWriter.beginArray();
                for (String supportedIdentityProvidersItem : supportedIdentityProviders) {
                    if (supportedIdentityProvidersItem == null) continue;
                    jsonWriter.value(supportedIdentityProvidersItem);
                }
                jsonWriter.endArray();
            }
            if (createUserPoolClientRequest.getCallbackURLs() != null) {
                List<String> callbackURLs = createUserPoolClientRequest.getCallbackURLs();
                jsonWriter.name("CallbackURLs");
                jsonWriter.beginArray();
                for (String callbackURLsItem : callbackURLs) {
                    if (callbackURLsItem == null) continue;
                    jsonWriter.value(callbackURLsItem);
                }
                jsonWriter.endArray();
            }
            if (createUserPoolClientRequest.getLogoutURLs() != null) {
                List<String> logoutURLs = createUserPoolClientRequest.getLogoutURLs();
                jsonWriter.name("LogoutURLs");
                jsonWriter.beginArray();
                for (String logoutURLsItem : logoutURLs) {
                    if (logoutURLsItem == null) continue;
                    jsonWriter.value(logoutURLsItem);
                }
                jsonWriter.endArray();
            }
            if (createUserPoolClientRequest.getDefaultRedirectURI() != null) {
                String defaultRedirectURI = createUserPoolClientRequest.getDefaultRedirectURI();
                jsonWriter.name("DefaultRedirectURI");
                jsonWriter.value(defaultRedirectURI);
            }
            if (createUserPoolClientRequest.getAllowedOAuthFlows() != null) {
                List<String> allowedOAuthFlows = createUserPoolClientRequest.getAllowedOAuthFlows();
                jsonWriter.name("AllowedOAuthFlows");
                jsonWriter.beginArray();
                for (String allowedOAuthFlowsItem : allowedOAuthFlows) {
                    if (allowedOAuthFlowsItem == null) continue;
                    jsonWriter.value(allowedOAuthFlowsItem);
                }
                jsonWriter.endArray();
            }
            if (createUserPoolClientRequest.getAllowedOAuthScopes() != null) {
                List<String> allowedOAuthScopes = createUserPoolClientRequest.getAllowedOAuthScopes();
                jsonWriter.name("AllowedOAuthScopes");
                jsonWriter.beginArray();
                for (String allowedOAuthScopesItem : allowedOAuthScopes) {
                    if (allowedOAuthScopesItem == null) continue;
                    jsonWriter.value(allowedOAuthScopesItem);
                }
                jsonWriter.endArray();
            }
            if (createUserPoolClientRequest.getAllowedOAuthFlowsUserPoolClient() != null) {
                Boolean allowedOAuthFlowsUserPoolClient = createUserPoolClientRequest.getAllowedOAuthFlowsUserPoolClient();
                jsonWriter.name("AllowedOAuthFlowsUserPoolClient");
                jsonWriter.value(allowedOAuthFlowsUserPoolClient.booleanValue());
            }
            if (createUserPoolClientRequest.getAnalyticsConfiguration() != null) {
                AnalyticsConfigurationType analyticsConfiguration = createUserPoolClientRequest.getAnalyticsConfiguration();
                jsonWriter.name("AnalyticsConfiguration");
                AnalyticsConfigurationTypeJsonMarshaller.getInstance().marshall(analyticsConfiguration, jsonWriter);
            }
            if (createUserPoolClientRequest.getPreventUserExistenceErrors() != null) {
                String preventUserExistenceErrors = createUserPoolClientRequest.getPreventUserExistenceErrors();
                jsonWriter.name("PreventUserExistenceErrors");
                jsonWriter.value(preventUserExistenceErrors);
            }
            if (createUserPoolClientRequest.getEnableTokenRevocation() != null) {
                Boolean enableTokenRevocation = createUserPoolClientRequest.getEnableTokenRevocation();
                jsonWriter.name("EnableTokenRevocation");
                jsonWriter.value(enableTokenRevocation.booleanValue());
            }
            if (createUserPoolClientRequest.getEnablePropagateAdditionalUserContextData() != null) {
                Boolean enablePropagateAdditionalUserContextData = createUserPoolClientRequest.getEnablePropagateAdditionalUserContextData();
                jsonWriter.name("EnablePropagateAdditionalUserContextData");
                jsonWriter.value(enablePropagateAdditionalUserContextData.booleanValue());
            }
            if (createUserPoolClientRequest.getAuthSessionValidity() != null) {
                Integer authSessionValidity = createUserPoolClientRequest.getAuthSessionValidity();
                jsonWriter.name("AuthSessionValidity");
                jsonWriter.value((Number)authSessionValidity);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

