/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.util.Base64;
import com.amazonaws.util.StringUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class CognitoDeviceHelper {
    private static final Log LOGGER = LogFactory.getLog(CognitoDeviceHelper.class);
    private static final String COGNITO_DEVICE_CACHE = "CognitoIdentityProviderDeviceCache";
    private static final String COGNITO_DEVICE_KEY = "DeviceKey";
    private static final String COGNITO_DEVICE_GROUP_KEY = "DeviceGroupKey";
    private static final String COGNITO_DEVICE_SECRET = "DeviceSecret";
    public static final int DEFAULT_DEVICE_PAGINATION_LIMIT = 10;
    static deviceSRP srpCalculator = null;

    public static String getDeviceName() {
        return Build.MODEL;
    }

    public static String getDeviceKey(String username, String userPoolId, Context context) {
        try {
            SharedPreferences cipCachedDeviceDetails = context.getSharedPreferences(CognitoDeviceHelper.getDeviceDetailsCacheForUser(username, userPoolId), 0);
            if (cipCachedDeviceDetails != null && cipCachedDeviceDetails.contains(COGNITO_DEVICE_KEY)) {
                return cipCachedDeviceDetails.getString(COGNITO_DEVICE_KEY, null);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error accessing SharedPreferences", (Throwable)e);
        }
        return null;
    }

    public static String getDeviceSecret(String username, String userPoolId, Context context) {
        try {
            SharedPreferences cipCachedDeviceDetails = context.getSharedPreferences(CognitoDeviceHelper.getDeviceDetailsCacheForUser(username, userPoolId), 0);
            if (cipCachedDeviceDetails != null && cipCachedDeviceDetails.contains(COGNITO_DEVICE_SECRET)) {
                return cipCachedDeviceDetails.getString(COGNITO_DEVICE_SECRET, null);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error accessing SharedPreferences", (Throwable)e);
        }
        return null;
    }

    public static String getDeviceGroupKey(String username, String userPoolId, Context context) {
        try {
            SharedPreferences cipCachedDeviceDetails = context.getSharedPreferences(CognitoDeviceHelper.getDeviceDetailsCacheForUser(username, userPoolId), 0);
            if (cipCachedDeviceDetails != null && cipCachedDeviceDetails.contains(COGNITO_DEVICE_GROUP_KEY)) {
                return cipCachedDeviceDetails.getString(COGNITO_DEVICE_GROUP_KEY, null);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error accessing SharedPreferences", (Throwable)e);
        }
        return null;
    }

    public static void cacheDeviceKey(String username, String userPoolId, String deviceKey, Context context) {
        try {
            SharedPreferences cipCachedDeviceDetails = context.getSharedPreferences(CognitoDeviceHelper.getDeviceDetailsCacheForUser(username, userPoolId), 0);
            cipCachedDeviceDetails.edit().putString(COGNITO_DEVICE_KEY, deviceKey).apply();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error accessing SharedPreferences", (Throwable)e);
        }
    }

    public static void cacheDeviceVerifier(String username, String userPoolId, String deviceSecret, Context context) {
        try {
            SharedPreferences cipCachedDeviceDetails = context.getSharedPreferences(CognitoDeviceHelper.getDeviceDetailsCacheForUser(username, userPoolId), 0);
            cipCachedDeviceDetails.edit().putString(COGNITO_DEVICE_SECRET, deviceSecret).apply();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error accessing SharedPreferences", (Throwable)e);
        }
    }

    public static void cacheDeviceGroupKey(String username, String userPoolId, String deviceGroupKey, Context context) {
        try {
            SharedPreferences cipCachedDeviceDetails = context.getSharedPreferences(CognitoDeviceHelper.getDeviceDetailsCacheForUser(username, userPoolId), 0);
            cipCachedDeviceDetails.edit().putString(COGNITO_DEVICE_GROUP_KEY, deviceGroupKey).apply();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error accessing SharedPreferences", (Throwable)e);
        }
    }

    public static void clearCachedDevice(String username, String userPoolId, Context context) {
        try {
            SharedPreferences cipCachedDeviceDetails = context.getSharedPreferences(CognitoDeviceHelper.getDeviceDetailsCacheForUser(username, userPoolId), 0);
            cipCachedDeviceDetails.edit().clear().apply();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error accessing SharedPreferences", (Throwable)e);
        }
    }

    public static Map<String, String> generateVerificationParameters(String deviceKey, String deviceGroup) {
        HashMap<String, String> devVerfPars = new HashMap<String, String>();
        String deviceSecret = CognitoDeviceHelper.generateRandomString();
        srpCalculator = new deviceSRP(deviceGroup, deviceKey, deviceSecret);
        byte[] salt = srpCalculator.getSalt().toByteArray();
        byte[] srpVerifier = srpCalculator.getVerifier().toByteArray();
        devVerfPars.put("salt", new String(Base64.encode((byte[])salt)));
        devVerfPars.put("verifier", new String(Base64.encode((byte[])srpVerifier)));
        devVerfPars.put("secret", deviceSecret);
        return devVerfPars;
    }

    private static String getDeviceDetailsCacheForUser(String username, String userPoolId) {
        return "CognitoIdentityProviderDeviceCache." + userPoolId + "." + username;
    }

    public static String generateRandomString() {
        UUID uuid = UUID.randomUUID();
        return String.valueOf(uuid);
    }

    public static class deviceSRP {
        private final BigInteger salt;
        private final BigInteger verifier;
        private static final String HASH_ALGORITHM = "SHA-256";
        private static final ThreadLocal<MessageDigest> THREAD_MESSAGE_DIGEST = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance(deviceSRP.HASH_ALGORITHM);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ExceptionInInitializerError(e);
                }
            }
        };
        private static final String HEX_N = "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF";
        private static final BigInteger N = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF", 16);
        private static final BigInteger GG = BigInteger.valueOf(2L);
        private static final SecureRandom SECURE_RANDOM;
        private static final int SALT_LENGTH_BITS = 128;

        public BigInteger getSalt() {
            return this.salt;
        }

        public BigInteger getVerifier() {
            return this.verifier;
        }

        public deviceSRP(String deviceGroupKey, String deviceKey, String password) {
            byte[] deviceKeyHash = this.getUserIdHash(deviceGroupKey, deviceKey, password);
            this.salt = new BigInteger(128, SECURE_RANDOM);
            this.verifier = deviceSRP.calcVerifier(this.salt, deviceKeyHash);
        }

        private static BigInteger calcVerifier(BigInteger salt, byte[] userIdHash) {
            deviceSRP.begin();
            deviceSRP.update(salt);
            deviceSRP.update(userIdHash);
            byte[] digest = deviceSRP.end();
            BigInteger x = new BigInteger(1, digest);
            return GG.modPow(x, N);
        }

        private byte[] getUserIdHash(String poolName, String userName, String password) {
            deviceSRP.begin();
            deviceSRP.update(poolName, userName, ":", password);
            return deviceSRP.end();
        }

        public static void begin() {
            MessageDigest md = THREAD_MESSAGE_DIGEST.get();
            md.reset();
        }

        public static byte[] end() {
            MessageDigest md = THREAD_MESSAGE_DIGEST.get();
            return md.digest();
        }

        public static void update(String ... strings) {
            MessageDigest md = THREAD_MESSAGE_DIGEST.get();
            for (String s : strings) {
                if (s == null) continue;
                md.update(s.getBytes(StringUtils.UTF8));
            }
        }

        public static void update(String s) {
            MessageDigest md = THREAD_MESSAGE_DIGEST.get();
            if (s != null) {
                md.update(s.getBytes(StringUtils.UTF8));
            }
        }

        public static void update(BigInteger ... bigInts) {
            MessageDigest md = THREAD_MESSAGE_DIGEST.get();
            for (BigInteger n : bigInts) {
                if (n == null) continue;
                md.update(n.toByteArray());
            }
        }

        public static void update(BigInteger n) {
            MessageDigest md = THREAD_MESSAGE_DIGEST.get();
            if (n != null) {
                md.update(n.toByteArray());
            }
        }

        public static void update(ByteBuffer b) {
            MessageDigest md = THREAD_MESSAGE_DIGEST.get();
            if (b != null) {
                md.update(b.array());
            }
        }

        public static void update(byte[] b) {
            MessageDigest md = THREAD_MESSAGE_DIGEST.get();
            if (b != null) {
                md.update(b);
            }
        }

        static {
            try {
                SECURE_RANDOM = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

