/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.CreateResourceServerRequest;
import com.amazonaws.services.cognitoidentityprovider.model.ResourceServerScopeType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.ResourceServerScopeTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateResourceServerRequestMarshaller
implements Marshaller<Request<CreateResourceServerRequest>, CreateResourceServerRequest> {
    public Request<CreateResourceServerRequest> marshall(CreateResourceServerRequest createResourceServerRequest) {
        if (createResourceServerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateResourceServerRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createResourceServerRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.CreateResourceServer";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (createResourceServerRequest.getUserPoolId() != null) {
                String userPoolId = createResourceServerRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (createResourceServerRequest.getIdentifier() != null) {
                String identifier = createResourceServerRequest.getIdentifier();
                jsonWriter.name("Identifier");
                jsonWriter.value(identifier);
            }
            if (createResourceServerRequest.getName() != null) {
                String name = createResourceServerRequest.getName();
                jsonWriter.name("Name");
                jsonWriter.value(name);
            }
            if (createResourceServerRequest.getScopes() != null) {
                List<ResourceServerScopeType> scopes = createResourceServerRequest.getScopes();
                jsonWriter.name("Scopes");
                jsonWriter.beginArray();
                for (ResourceServerScopeType scopesItem : scopes) {
                    if (scopesItem == null) continue;
                    ResourceServerScopeTypeJsonMarshaller.getInstance().marshall(scopesItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

