/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdminUpdateUserAttributesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String userPoolId;
    private String username;
    private List<AttributeType> userAttributes;
    private Map<String, String> clientMetadata;

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public AdminUpdateUserAttributesRequest withUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public AdminUpdateUserAttributesRequest withUsername(String username) {
        this.username = username;
        return this;
    }

    public List<AttributeType> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(Collection<AttributeType> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
            return;
        }
        this.userAttributes = new ArrayList<AttributeType>(userAttributes);
    }

    public AdminUpdateUserAttributesRequest withUserAttributes(AttributeType ... userAttributes) {
        if (this.getUserAttributes() == null) {
            this.userAttributes = new ArrayList<AttributeType>(userAttributes.length);
        }
        for (AttributeType value : userAttributes) {
            this.userAttributes.add(value);
        }
        return this;
    }

    public AdminUpdateUserAttributesRequest withUserAttributes(Collection<AttributeType> userAttributes) {
        this.setUserAttributes(userAttributes);
        return this;
    }

    public Map<String, String> getClientMetadata() {
        return this.clientMetadata;
    }

    public void setClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
    }

    public AdminUpdateUserAttributesRequest withClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
        return this;
    }

    public AdminUpdateUserAttributesRequest addClientMetadataEntry(String key, String value) {
        if (null == this.clientMetadata) {
            this.clientMetadata = new HashMap<String, String>();
        }
        if (this.clientMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.clientMetadata.put(key, value);
        return this;
    }

    public AdminUpdateUserAttributesRequest clearClientMetadataEntries() {
        this.clientMetadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolId() != null) {
            sb.append("UserPoolId: " + this.getUserPoolId() + ",");
        }
        if (this.getUsername() != null) {
            sb.append("Username: " + this.getUsername() + ",");
        }
        if (this.getUserAttributes() != null) {
            sb.append("UserAttributes: " + this.getUserAttributes() + ",");
        }
        if (this.getClientMetadata() != null) {
            sb.append("ClientMetadata: " + this.getClientMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolId() == null ? 0 : this.getUserPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttributes() == null ? 0 : this.getUserAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getClientMetadata() == null ? 0 : this.getClientMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminUpdateUserAttributesRequest)) {
            return false;
        }
        AdminUpdateUserAttributesRequest other = (AdminUpdateUserAttributesRequest)obj;
        if (other.getUserPoolId() == null ^ this.getUserPoolId() == null) {
            return false;
        }
        if (other.getUserPoolId() != null && !other.getUserPoolId().equals(this.getUserPoolId())) {
            return false;
        }
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getUserAttributes() == null ^ this.getUserAttributes() == null) {
            return false;
        }
        if (other.getUserAttributes() != null && !other.getUserAttributes().equals(this.getUserAttributes())) {
            return false;
        }
        if (other.getClientMetadata() == null ^ this.getClientMetadata() == null) {
            return false;
        }
        return other.getClientMetadata() == null || other.getClientMetadata().equals(this.getClientMetadata());
    }
}

