/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import com.amazonaws.services.cognitoidentityprovider.model.InitiateAuthRequest;
import com.amazonaws.services.cognitoidentityprovider.model.UserContextDataType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AnalyticsMetadataTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.UserContextDataTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class InitiateAuthRequestMarshaller
implements Marshaller<Request<InitiateAuthRequest>, InitiateAuthRequest> {
    public Request<InitiateAuthRequest> marshall(InitiateAuthRequest initiateAuthRequest) {
        if (initiateAuthRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(InitiateAuthRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)initiateAuthRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.InitiateAuth";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (initiateAuthRequest.getAuthFlow() != null) {
                String authFlow = initiateAuthRequest.getAuthFlow();
                jsonWriter.name("AuthFlow");
                jsonWriter.value(authFlow);
            }
            if (initiateAuthRequest.getAuthParameters() != null) {
                Map<String, String> authParameters = initiateAuthRequest.getAuthParameters();
                jsonWriter.name("AuthParameters");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> authParametersEntry : authParameters.entrySet()) {
                    String authParametersValue = authParametersEntry.getValue();
                    if (authParametersValue == null) continue;
                    jsonWriter.name(authParametersEntry.getKey());
                    jsonWriter.value(authParametersValue);
                }
                jsonWriter.endObject();
            }
            if (initiateAuthRequest.getClientMetadata() != null) {
                Map<String, String> clientMetadata = initiateAuthRequest.getClientMetadata();
                jsonWriter.name("ClientMetadata");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> clientMetadataEntry : clientMetadata.entrySet()) {
                    String clientMetadataValue = clientMetadataEntry.getValue();
                    if (clientMetadataValue == null) continue;
                    jsonWriter.name(clientMetadataEntry.getKey());
                    jsonWriter.value(clientMetadataValue);
                }
                jsonWriter.endObject();
            }
            if (initiateAuthRequest.getClientId() != null) {
                String clientId = initiateAuthRequest.getClientId();
                jsonWriter.name("ClientId");
                jsonWriter.value(clientId);
            }
            if (initiateAuthRequest.getUserContextData() != null) {
                UserContextDataType userContextData = initiateAuthRequest.getUserContextData();
                jsonWriter.name("UserContextData");
                UserContextDataTypeJsonMarshaller.getInstance().marshall(userContextData, jsonWriter);
            }
            if (initiateAuthRequest.getAnalyticsMetadata() != null) {
                AnalyticsMetadataType analyticsMetadata = initiateAuthRequest.getAnalyticsMetadata();
                jsonWriter.name("AnalyticsMetadata");
                AnalyticsMetadataTypeJsonMarshaller.getInstance().marshall(analyticsMetadata, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

