/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.SetUserPoolMfaConfigRequest;
import com.amazonaws.services.cognitoidentityprovider.model.SmsMfaConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.SoftwareTokenMfaConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.SmsMfaConfigTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.SoftwareTokenMfaConfigTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class SetUserPoolMfaConfigRequestMarshaller
implements Marshaller<Request<SetUserPoolMfaConfigRequest>, SetUserPoolMfaConfigRequest> {
    public Request<SetUserPoolMfaConfigRequest> marshall(SetUserPoolMfaConfigRequest setUserPoolMfaConfigRequest) {
        if (setUserPoolMfaConfigRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetUserPoolMfaConfigRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setUserPoolMfaConfigRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.SetUserPoolMfaConfig";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (setUserPoolMfaConfigRequest.getUserPoolId() != null) {
                String userPoolId = setUserPoolMfaConfigRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (setUserPoolMfaConfigRequest.getSmsMfaConfiguration() != null) {
                SmsMfaConfigType smsMfaConfiguration = setUserPoolMfaConfigRequest.getSmsMfaConfiguration();
                jsonWriter.name("SmsMfaConfiguration");
                SmsMfaConfigTypeJsonMarshaller.getInstance().marshall(smsMfaConfiguration, jsonWriter);
            }
            if (setUserPoolMfaConfigRequest.getSoftwareTokenMfaConfiguration() != null) {
                SoftwareTokenMfaConfigType softwareTokenMfaConfiguration = setUserPoolMfaConfigRequest.getSoftwareTokenMfaConfiguration();
                jsonWriter.name("SoftwareTokenMfaConfiguration");
                SoftwareTokenMfaConfigTypeJsonMarshaller.getInstance().marshall(softwareTokenMfaConfiguration, jsonWriter);
            }
            if (setUserPoolMfaConfigRequest.getMfaConfiguration() != null) {
                String mfaConfiguration = setUserPoolMfaConfigRequest.getMfaConfiguration();
                jsonWriter.name("MfaConfiguration");
                jsonWriter.value(mfaConfiguration);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

