/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.DeviceType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AttributeTypeJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class DeviceTypeJsonUnmarshaller
implements Unmarshaller<DeviceType, JsonUnmarshallerContext> {
    private static DeviceTypeJsonUnmarshaller instance;

    DeviceTypeJsonUnmarshaller() {
    }

    public DeviceType unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeviceType deviceType = new DeviceType();
        AwsJsonReader reader = context.getReader();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("DeviceKey")) {
                deviceType.setDeviceKey(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("DeviceAttributes")) {
                deviceType.setDeviceAttributes(new ListUnmarshaller((Unmarshaller)AttributeTypeJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("DeviceCreateDate")) {
                deviceType.setDeviceCreateDate(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("DeviceLastModifiedDate")) {
                deviceType.setDeviceLastModifiedDate(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("DeviceLastAccessedDate")) {
                deviceType.setDeviceLastAccessedDate(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return deviceType;
    }

    public static DeviceTypeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DeviceTypeJsonUnmarshaller();
        }
        return instance;
    }
}

