/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.DeviceType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AttributeTypeJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;

class DeviceTypeJsonMarshaller {
    private static DeviceTypeJsonMarshaller instance;

    DeviceTypeJsonMarshaller() {
    }

    public void marshall(DeviceType deviceType, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (deviceType.getDeviceKey() != null) {
            String deviceKey = deviceType.getDeviceKey();
            jsonWriter.name("DeviceKey");
            jsonWriter.value(deviceKey);
        }
        if (deviceType.getDeviceAttributes() != null) {
            List<AttributeType> deviceAttributes = deviceType.getDeviceAttributes();
            jsonWriter.name("DeviceAttributes");
            jsonWriter.beginArray();
            for (AttributeType deviceAttributesItem : deviceAttributes) {
                if (deviceAttributesItem == null) continue;
                AttributeTypeJsonMarshaller.getInstance().marshall(deviceAttributesItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (deviceType.getDeviceCreateDate() != null) {
            Date deviceCreateDate = deviceType.getDeviceCreateDate();
            jsonWriter.name("DeviceCreateDate");
            jsonWriter.value(deviceCreateDate);
        }
        if (deviceType.getDeviceLastModifiedDate() != null) {
            Date deviceLastModifiedDate = deviceType.getDeviceLastModifiedDate();
            jsonWriter.name("DeviceLastModifiedDate");
            jsonWriter.value(deviceLastModifiedDate);
        }
        if (deviceType.getDeviceLastAccessedDate() != null) {
            Date deviceLastAccessedDate = deviceType.getDeviceLastAccessedDate();
            jsonWriter.name("DeviceLastAccessedDate");
            jsonWriter.value(deviceLastAccessedDate);
        }
        jsonWriter.endObject();
    }

    public static DeviceTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeviceTypeJsonMarshaller();
        }
        return instance;
    }
}

