/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations;

import android.content.Context;
import android.os.Handler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.CognitoIdentityProviderContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;
import com.amazonaws.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest;
import com.amazonaws.services.cognitoidentityprovider.model.RespondToAuthChallengeResult;
import java.util.HashMap;
import java.util.Map;

public class ChallengeContinuation
implements CognitoIdentityProviderContinuation<Map<String, String>> {
    public static final boolean RUN_IN_BACKGROUND = true;
    public static final boolean RUN_IN_CURRENT = false;
    private final RespondToAuthChallengeResult challengeResult;
    private final Context context;
    private final String clientId;
    private final CognitoUser user;
    private final AuthenticationHandler callback;
    private Map<String, String> challengeResponses;
    private boolean runInBackground;

    public ChallengeContinuation(CognitoUser user, Context context, String clientId, RespondToAuthChallengeResult challengeResult, boolean runInBackground, AuthenticationHandler callback) {
        this.challengeResult = challengeResult;
        this.context = context;
        this.clientId = clientId;
        this.user = user;
        this.callback = callback;
        this.runInBackground = runInBackground;
        this.challengeResponses = new HashMap<String, String>();
    }

    @Override
    public Map<String, String> getParameters() {
        return this.challengeResult.getChallengeParameters();
    }

    public void setChallengeResponse(String responseKey, String responseValue) {
        this.challengeResponses.put(responseKey, responseValue);
    }

    @Override
    public void continueTask() {
        final RespondToAuthChallengeRequest respondToAuthChallengeRequest = new RespondToAuthChallengeRequest();
        respondToAuthChallengeRequest.setChallengeName(this.challengeResult.getChallengeName());
        respondToAuthChallengeRequest.setSession(this.challengeResult.getSession());
        respondToAuthChallengeRequest.setClientId(null);
        if (this.runInBackground) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Runnable nextStep;
                    Handler handler = new Handler(ChallengeContinuation.this.context.getMainLooper());
                    try {
                        nextStep = ChallengeContinuation.this.user.respondToChallenge(respondToAuthChallengeRequest, ChallengeContinuation.this.callback, true);
                    }
                    catch (Exception e) {
                        nextStep = new Runnable(){

                            @Override
                            public void run() {
                                ChallengeContinuation.this.callback.onFailure(e);
                            }
                        };
                    }
                    handler.post(nextStep);
                }
            }).start();
        } else {
            Runnable nextStep;
            try {
                nextStep = this.user.respondToChallenge(respondToAuthChallengeRequest, this.callback, false);
            }
            catch (Exception e) {
                nextStep = new Runnable(){

                    @Override
                    public void run() {
                        ChallengeContinuation.this.callback.onFailure(e);
                    }
                };
            }
            nextStep.run();
        }
    }
}

