/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.AdminUpdateUserAttributesRequest;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class AdminUpdateUserAttributesRequestMarshaller
implements Marshaller<Request<AdminUpdateUserAttributesRequest>, AdminUpdateUserAttributesRequest> {
    public Request<AdminUpdateUserAttributesRequest> marshall(AdminUpdateUserAttributesRequest adminUpdateUserAttributesRequest) {
        if (adminUpdateUserAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)adminUpdateUserAttributesRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.AdminUpdateUserAttributes";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag userAttributesList;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (adminUpdateUserAttributesRequest.getUserPoolId() != null) {
                jsonWriter.name("UserPoolId").value(adminUpdateUserAttributesRequest.getUserPoolId());
            }
            if (adminUpdateUserAttributesRequest.getUsername() != null) {
                jsonWriter.name("Username").value(adminUpdateUserAttributesRequest.getUsername());
            }
            if (!((userAttributesList = (ListWithAutoConstructFlag)adminUpdateUserAttributesRequest.getUserAttributes()) == null || userAttributesList.isAutoConstruct() && userAttributesList.isEmpty())) {
                jsonWriter.name("UserAttributes");
                jsonWriter.beginArray();
                for (AttributeType userAttributesListValue : userAttributesList) {
                    if (userAttributesListValue == null) continue;
                    jsonWriter.beginObject();
                    if (userAttributesListValue.getName() != null) {
                        jsonWriter.name("Name").value(userAttributesListValue.getName());
                    }
                    if (userAttributesListValue.getValue() != null) {
                        jsonWriter.name("Value").value(userAttributesListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

