/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.UserType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListUsersResult
implements Serializable {
    private ListWithAutoConstructFlag<UserType> users;
    private String paginationToken;

    public List<UserType> getUsers() {
        if (this.users == null) {
            this.users = new ListWithAutoConstructFlag();
            this.users.setAutoConstruct(true);
        }
        return this.users;
    }

    public void setUsers(Collection<UserType> users) {
        if (users == null) {
            this.users = null;
            return;
        }
        ListWithAutoConstructFlag usersCopy = new ListWithAutoConstructFlag(users.size());
        usersCopy.addAll(users);
        this.users = usersCopy;
    }

    public ListUsersResult withUsers(UserType ... users) {
        if (this.getUsers() == null) {
            this.setUsers(new ArrayList<UserType>(users.length));
        }
        for (UserType value : users) {
            this.getUsers().add(value);
        }
        return this;
    }

    public ListUsersResult withUsers(Collection<UserType> users) {
        if (users == null) {
            this.users = null;
        } else {
            ListWithAutoConstructFlag usersCopy = new ListWithAutoConstructFlag(users.size());
            usersCopy.addAll(users);
            this.users = usersCopy;
        }
        return this;
    }

    public String getPaginationToken() {
        return this.paginationToken;
    }

    public void setPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
    }

    public ListUsersResult withPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsers() != null) {
            sb.append("Users: " + this.getUsers() + ",");
        }
        if (this.getPaginationToken() != null) {
            sb.append("PaginationToken: " + this.getPaginationToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsers() == null ? 0 : this.getUsers().hashCode());
        hashCode = 31 * hashCode + (this.getPaginationToken() == null ? 0 : this.getPaginationToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersResult)) {
            return false;
        }
        ListUsersResult other = (ListUsersResult)obj;
        if (other.getUsers() == null ^ this.getUsers() == null) {
            return false;
        }
        if (other.getUsers() != null && !other.getUsers().equals(this.getUsers())) {
            return false;
        }
        if (other.getPaginationToken() == null ^ this.getPaginationToken() == null) {
            return false;
        }
        return other.getPaginationToken() == null || other.getPaginationToken().equals(this.getPaginationToken());
    }
}

