/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import java.io.Serializable;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * Container for the parameters to the {@link com.amazonaws.services.cognitoidentityprovider.AmazonCognitoIdentityProvider#verifyUserAttribute(VerifyUserAttributeRequest) VerifyUserAttribute operation}.
 * <p>
 * Verifies the specified user attributes in the user pool.
 * </p>
 *
 * @see com.amazonaws.services.cognitoidentityprovider.AmazonCognitoIdentityProvider#verifyUserAttribute(VerifyUserAttributeRequest)
 */
public class VerifyUserAttributeRequest extends AmazonWebServiceRequest implements Serializable {

    /**
     * Represents the access token of the request to verify user attributes.
     */
    private String accessToken;

    /**
     * The attribute name in the request to verify user attributes.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 32<br/>
     * <b>Pattern: </b>[\p{L}\p{M}\p{S}\p{N}\p{P}]+<br/>
     */
    private String attributeName;

    /**
     * The verification code in the request to verify user attributes.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 2048<br/>
     * <b>Pattern: </b>[\S]+<br/>
     */
    private String code;

    /**
     * Represents the access token of the request to verify user attributes.
     *
     * @return Represents the access token of the request to verify user attributes.
     */
    public String getAccessToken() {
        return accessToken;
    }
    
    /**
     * Represents the access token of the request to verify user attributes.
     *
     * @param accessToken Represents the access token of the request to verify user attributes.
     */
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }
    
    /**
     * Represents the access token of the request to verify user attributes.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param accessToken Represents the access token of the request to verify user attributes.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public VerifyUserAttributeRequest withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    /**
     * The attribute name in the request to verify user attributes.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 32<br/>
     * <b>Pattern: </b>[\p{L}\p{M}\p{S}\p{N}\p{P}]+<br/>
     *
     * @return The attribute name in the request to verify user attributes.
     */
    public String getAttributeName() {
        return attributeName;
    }
    
    /**
     * The attribute name in the request to verify user attributes.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 32<br/>
     * <b>Pattern: </b>[\p{L}\p{M}\p{S}\p{N}\p{P}]+<br/>
     *
     * @param attributeName The attribute name in the request to verify user attributes.
     */
    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }
    
    /**
     * The attribute name in the request to verify user attributes.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 32<br/>
     * <b>Pattern: </b>[\p{L}\p{M}\p{S}\p{N}\p{P}]+<br/>
     *
     * @param attributeName The attribute name in the request to verify user attributes.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public VerifyUserAttributeRequest withAttributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    /**
     * The verification code in the request to verify user attributes.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 2048<br/>
     * <b>Pattern: </b>[\S]+<br/>
     *
     * @return The verification code in the request to verify user attributes.
     */
    public String getCode() {
        return code;
    }
    
    /**
     * The verification code in the request to verify user attributes.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 2048<br/>
     * <b>Pattern: </b>[\S]+<br/>
     *
     * @param code The verification code in the request to verify user attributes.
     */
    public void setCode(String code) {
        this.code = code;
    }
    
    /**
     * The verification code in the request to verify user attributes.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 2048<br/>
     * <b>Pattern: </b>[\S]+<br/>
     *
     * @param code The verification code in the request to verify user attributes.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public VerifyUserAttributeRequest withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAccessToken() != null) sb.append("AccessToken: " + getAccessToken() + ",");
        if (getAttributeName() != null) sb.append("AttributeName: " + getAttributeName() + ",");
        if (getCode() != null) sb.append("Code: " + getCode() );
        sb.append("}");
        return sb.toString();
    }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;
        
        hashCode = prime * hashCode + ((getAccessToken() == null) ? 0 : getAccessToken().hashCode()); 
        hashCode = prime * hashCode + ((getAttributeName() == null) ? 0 : getAttributeName().hashCode()); 
        hashCode = prime * hashCode + ((getCode() == null) ? 0 : getCode().hashCode()); 
        return hashCode;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;

        if (obj instanceof VerifyUserAttributeRequest == false) return false;
        VerifyUserAttributeRequest other = (VerifyUserAttributeRequest)obj;
        
        if (other.getAccessToken() == null ^ this.getAccessToken() == null) return false;
        if (other.getAccessToken() != null && other.getAccessToken().equals(this.getAccessToken()) == false) return false; 
        if (other.getAttributeName() == null ^ this.getAttributeName() == null) return false;
        if (other.getAttributeName() != null && other.getAttributeName().equals(this.getAttributeName()) == false) return false; 
        if (other.getCode() == null ^ this.getCode() == null) return false;
        if (other.getCode() != null && other.getCode().equals(this.getCode()) == false) return false; 
        return true;
    }
    
}
    