/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.AliasAttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.LambdaConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolMfaType;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolPolicyType;
import com.amazonaws.services.cognitoidentityprovider.model.VerifiedAttributeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateUserPoolRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String poolName;
    private UserPoolPolicyType policies;
    private LambdaConfigType lambdaConfig;
    private ListWithAutoConstructFlag<String> autoVerifiedAttributes;
    private ListWithAutoConstructFlag<String> aliasAttributes;
    private String smsVerificationMessage;
    private String emailVerificationMessage;
    private String emailVerificationSubject;
    private String smsAuthenticationMessage;
    private String mfaConfiguration;

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public CreateUserPoolRequest withPoolName(String poolName) {
        this.poolName = poolName;
        return this;
    }

    public UserPoolPolicyType getPolicies() {
        return this.policies;
    }

    public void setPolicies(UserPoolPolicyType policies) {
        this.policies = policies;
    }

    public CreateUserPoolRequest withPolicies(UserPoolPolicyType policies) {
        this.policies = policies;
        return this;
    }

    public LambdaConfigType getLambdaConfig() {
        return this.lambdaConfig;
    }

    public void setLambdaConfig(LambdaConfigType lambdaConfig) {
        this.lambdaConfig = lambdaConfig;
    }

    public CreateUserPoolRequest withLambdaConfig(LambdaConfigType lambdaConfig) {
        this.lambdaConfig = lambdaConfig;
        return this;
    }

    public List<String> getAutoVerifiedAttributes() {
        if (this.autoVerifiedAttributes == null) {
            this.autoVerifiedAttributes = new ListWithAutoConstructFlag();
            this.autoVerifiedAttributes.setAutoConstruct(true);
        }
        return this.autoVerifiedAttributes;
    }

    public void setAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
        if (autoVerifiedAttributes == null) {
            this.autoVerifiedAttributes = null;
            return;
        }
        ListWithAutoConstructFlag autoVerifiedAttributesCopy = new ListWithAutoConstructFlag(autoVerifiedAttributes.size());
        autoVerifiedAttributesCopy.addAll(autoVerifiedAttributes);
        this.autoVerifiedAttributes = autoVerifiedAttributesCopy;
    }

    public CreateUserPoolRequest withAutoVerifiedAttributes(String ... autoVerifiedAttributes) {
        if (this.getAutoVerifiedAttributes() == null) {
            this.setAutoVerifiedAttributes(new ArrayList<String>(autoVerifiedAttributes.length));
        }
        for (String value : autoVerifiedAttributes) {
            this.getAutoVerifiedAttributes().add(value);
        }
        return this;
    }

    public CreateUserPoolRequest withAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
        if (autoVerifiedAttributes == null) {
            this.autoVerifiedAttributes = null;
        } else {
            ListWithAutoConstructFlag autoVerifiedAttributesCopy = new ListWithAutoConstructFlag(autoVerifiedAttributes.size());
            autoVerifiedAttributesCopy.addAll(autoVerifiedAttributes);
            this.autoVerifiedAttributes = autoVerifiedAttributesCopy;
        }
        return this;
    }

    public CreateUserPoolRequest withAutoVerifiedAttributes(VerifiedAttributeType ... autoVerifiedAttributes) {
        ArrayList<String> autoVerifiedAttributesCopy = new ArrayList<String>(autoVerifiedAttributes.length);
        for (VerifiedAttributeType member : autoVerifiedAttributes) {
            autoVerifiedAttributesCopy.add(member.toString());
        }
        if (this.getAutoVerifiedAttributes() == null) {
            this.setAutoVerifiedAttributes(autoVerifiedAttributesCopy);
        } else {
            this.getAutoVerifiedAttributes().addAll(autoVerifiedAttributesCopy);
        }
        return this;
    }

    public List<String> getAliasAttributes() {
        if (this.aliasAttributes == null) {
            this.aliasAttributes = new ListWithAutoConstructFlag();
            this.aliasAttributes.setAutoConstruct(true);
        }
        return this.aliasAttributes;
    }

    public void setAliasAttributes(Collection<String> aliasAttributes) {
        if (aliasAttributes == null) {
            this.aliasAttributes = null;
            return;
        }
        ListWithAutoConstructFlag aliasAttributesCopy = new ListWithAutoConstructFlag(aliasAttributes.size());
        aliasAttributesCopy.addAll(aliasAttributes);
        this.aliasAttributes = aliasAttributesCopy;
    }

    public CreateUserPoolRequest withAliasAttributes(String ... aliasAttributes) {
        if (this.getAliasAttributes() == null) {
            this.setAliasAttributes(new ArrayList<String>(aliasAttributes.length));
        }
        for (String value : aliasAttributes) {
            this.getAliasAttributes().add(value);
        }
        return this;
    }

    public CreateUserPoolRequest withAliasAttributes(Collection<String> aliasAttributes) {
        if (aliasAttributes == null) {
            this.aliasAttributes = null;
        } else {
            ListWithAutoConstructFlag aliasAttributesCopy = new ListWithAutoConstructFlag(aliasAttributes.size());
            aliasAttributesCopy.addAll(aliasAttributes);
            this.aliasAttributes = aliasAttributesCopy;
        }
        return this;
    }

    public CreateUserPoolRequest withAliasAttributes(AliasAttributeType ... aliasAttributes) {
        ArrayList<String> aliasAttributesCopy = new ArrayList<String>(aliasAttributes.length);
        for (AliasAttributeType member : aliasAttributes) {
            aliasAttributesCopy.add(member.toString());
        }
        if (this.getAliasAttributes() == null) {
            this.setAliasAttributes(aliasAttributesCopy);
        } else {
            this.getAliasAttributes().addAll(aliasAttributesCopy);
        }
        return this;
    }

    public String getSmsVerificationMessage() {
        return this.smsVerificationMessage;
    }

    public void setSmsVerificationMessage(String smsVerificationMessage) {
        this.smsVerificationMessage = smsVerificationMessage;
    }

    public CreateUserPoolRequest withSmsVerificationMessage(String smsVerificationMessage) {
        this.smsVerificationMessage = smsVerificationMessage;
        return this;
    }

    public String getEmailVerificationMessage() {
        return this.emailVerificationMessage;
    }

    public void setEmailVerificationMessage(String emailVerificationMessage) {
        this.emailVerificationMessage = emailVerificationMessage;
    }

    public CreateUserPoolRequest withEmailVerificationMessage(String emailVerificationMessage) {
        this.emailVerificationMessage = emailVerificationMessage;
        return this;
    }

    public String getEmailVerificationSubject() {
        return this.emailVerificationSubject;
    }

    public void setEmailVerificationSubject(String emailVerificationSubject) {
        this.emailVerificationSubject = emailVerificationSubject;
    }

    public CreateUserPoolRequest withEmailVerificationSubject(String emailVerificationSubject) {
        this.emailVerificationSubject = emailVerificationSubject;
        return this;
    }

    public String getSmsAuthenticationMessage() {
        return this.smsAuthenticationMessage;
    }

    public void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
        this.smsAuthenticationMessage = smsAuthenticationMessage;
    }

    public CreateUserPoolRequest withSmsAuthenticationMessage(String smsAuthenticationMessage) {
        this.smsAuthenticationMessage = smsAuthenticationMessage;
        return this;
    }

    public String getMfaConfiguration() {
        return this.mfaConfiguration;
    }

    public void setMfaConfiguration(String mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration;
    }

    public CreateUserPoolRequest withMfaConfiguration(String mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration;
        return this;
    }

    public void setMfaConfiguration(UserPoolMfaType mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration.toString();
    }

    public CreateUserPoolRequest withMfaConfiguration(UserPoolMfaType mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPoolName() != null) {
            sb.append("PoolName: " + this.getPoolName() + ",");
        }
        if (this.getPolicies() != null) {
            sb.append("Policies: " + this.getPolicies() + ",");
        }
        if (this.getLambdaConfig() != null) {
            sb.append("LambdaConfig: " + this.getLambdaConfig() + ",");
        }
        if (this.getAutoVerifiedAttributes() != null) {
            sb.append("AutoVerifiedAttributes: " + this.getAutoVerifiedAttributes() + ",");
        }
        if (this.getAliasAttributes() != null) {
            sb.append("AliasAttributes: " + this.getAliasAttributes() + ",");
        }
        if (this.getSmsVerificationMessage() != null) {
            sb.append("SmsVerificationMessage: " + this.getSmsVerificationMessage() + ",");
        }
        if (this.getEmailVerificationMessage() != null) {
            sb.append("EmailVerificationMessage: " + this.getEmailVerificationMessage() + ",");
        }
        if (this.getEmailVerificationSubject() != null) {
            sb.append("EmailVerificationSubject: " + this.getEmailVerificationSubject() + ",");
        }
        if (this.getSmsAuthenticationMessage() != null) {
            sb.append("SmsAuthenticationMessage: " + this.getSmsAuthenticationMessage() + ",");
        }
        if (this.getMfaConfiguration() != null) {
            sb.append("MfaConfiguration: " + this.getMfaConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPoolName() == null ? 0 : this.getPoolName().hashCode());
        hashCode = 31 * hashCode + (this.getPolicies() == null ? 0 : this.getPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getLambdaConfig() == null ? 0 : this.getLambdaConfig().hashCode());
        hashCode = 31 * hashCode + (this.getAutoVerifiedAttributes() == null ? 0 : this.getAutoVerifiedAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getAliasAttributes() == null ? 0 : this.getAliasAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getSmsVerificationMessage() == null ? 0 : this.getSmsVerificationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getEmailVerificationMessage() == null ? 0 : this.getEmailVerificationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getEmailVerificationSubject() == null ? 0 : this.getEmailVerificationSubject().hashCode());
        hashCode = 31 * hashCode + (this.getSmsAuthenticationMessage() == null ? 0 : this.getSmsAuthenticationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getMfaConfiguration() == null ? 0 : this.getMfaConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserPoolRequest)) {
            return false;
        }
        CreateUserPoolRequest other = (CreateUserPoolRequest)obj;
        if (other.getPoolName() == null ^ this.getPoolName() == null) {
            return false;
        }
        if (other.getPoolName() != null && !other.getPoolName().equals(this.getPoolName())) {
            return false;
        }
        if (other.getPolicies() == null ^ this.getPolicies() == null) {
            return false;
        }
        if (other.getPolicies() != null && !other.getPolicies().equals(this.getPolicies())) {
            return false;
        }
        if (other.getLambdaConfig() == null ^ this.getLambdaConfig() == null) {
            return false;
        }
        if (other.getLambdaConfig() != null && !other.getLambdaConfig().equals(this.getLambdaConfig())) {
            return false;
        }
        if (other.getAutoVerifiedAttributes() == null ^ this.getAutoVerifiedAttributes() == null) {
            return false;
        }
        if (other.getAutoVerifiedAttributes() != null && !other.getAutoVerifiedAttributes().equals(this.getAutoVerifiedAttributes())) {
            return false;
        }
        if (other.getAliasAttributes() == null ^ this.getAliasAttributes() == null) {
            return false;
        }
        if (other.getAliasAttributes() != null && !other.getAliasAttributes().equals(this.getAliasAttributes())) {
            return false;
        }
        if (other.getSmsVerificationMessage() == null ^ this.getSmsVerificationMessage() == null) {
            return false;
        }
        if (other.getSmsVerificationMessage() != null && !other.getSmsVerificationMessage().equals(this.getSmsVerificationMessage())) {
            return false;
        }
        if (other.getEmailVerificationMessage() == null ^ this.getEmailVerificationMessage() == null) {
            return false;
        }
        if (other.getEmailVerificationMessage() != null && !other.getEmailVerificationMessage().equals(this.getEmailVerificationMessage())) {
            return false;
        }
        if (other.getEmailVerificationSubject() == null ^ this.getEmailVerificationSubject() == null) {
            return false;
        }
        if (other.getEmailVerificationSubject() != null && !other.getEmailVerificationSubject().equals(this.getEmailVerificationSubject())) {
            return false;
        }
        if (other.getSmsAuthenticationMessage() == null ^ this.getSmsAuthenticationMessage() == null) {
            return false;
        }
        if (other.getSmsAuthenticationMessage() != null && !other.getSmsAuthenticationMessage().equals(this.getSmsAuthenticationMessage())) {
            return false;
        }
        if (other.getMfaConfiguration() == null ^ this.getMfaConfiguration() == null) {
            return false;
        }
        return other.getMfaConfiguration() == null || other.getMfaConfiguration().equals(this.getMfaConfiguration());
    }
}

