/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.KeyType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetJWKSResult
implements Serializable {
    private ListWithAutoConstructFlag<KeyType> keys;

    public List<KeyType> getKeys() {
        if (this.keys == null) {
            this.keys = new ListWithAutoConstructFlag();
            this.keys.setAutoConstruct(true);
        }
        return this.keys;
    }

    public void setKeys(Collection<KeyType> keys) {
        if (keys == null) {
            this.keys = null;
            return;
        }
        ListWithAutoConstructFlag keysCopy = new ListWithAutoConstructFlag(keys.size());
        keysCopy.addAll(keys);
        this.keys = keysCopy;
    }

    public GetJWKSResult withKeys(KeyType ... keys) {
        if (this.getKeys() == null) {
            this.setKeys(new ArrayList<KeyType>(keys.length));
        }
        for (KeyType value : keys) {
            this.getKeys().add(value);
        }
        return this;
    }

    public GetJWKSResult withKeys(Collection<KeyType> keys) {
        if (keys == null) {
            this.keys = null;
        } else {
            ListWithAutoConstructFlag keysCopy = new ListWithAutoConstructFlag(keys.size());
            keysCopy.addAll(keys);
            this.keys = keysCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeys() != null) {
            sb.append("Keys: " + this.getKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeys() == null ? 0 : this.getKeys().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJWKSResult)) {
            return false;
        }
        GetJWKSResult other = (GetJWKSResult)obj;
        if (other.getKeys() == null ^ this.getKeys() == null) {
            return false;
        }
        return other.getKeys() == null || other.getKeys().equals(this.getKeys());
    }
}

