/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class GetUserAttributeVerificationCodeRequestMarshaller
implements Marshaller<Request<GetUserAttributeVerificationCodeRequest>, GetUserAttributeVerificationCodeRequest> {
    public Request<GetUserAttributeVerificationCodeRequest> marshall(GetUserAttributeVerificationCodeRequest getUserAttributeVerificationCodeRequest) {
        if (getUserAttributeVerificationCodeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetUserAttributeVerificationCodeRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getUserAttributeVerificationCodeRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.GetUserAttributeVerificationCode";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (getUserAttributeVerificationCodeRequest.getAccessToken() != null) {
                String accessToken = getUserAttributeVerificationCodeRequest.getAccessToken();
                jsonWriter.name("AccessToken");
                jsonWriter.value(accessToken);
            }
            if (getUserAttributeVerificationCodeRequest.getAttributeName() != null) {
                String attributeName = getUserAttributeVerificationCodeRequest.getAttributeName();
                jsonWriter.name("AttributeName");
                jsonWriter.value(attributeName);
            }
            if (getUserAttributeVerificationCodeRequest.getClientMetadata() != null) {
                Map<String, String> clientMetadata = getUserAttributeVerificationCodeRequest.getClientMetadata();
                jsonWriter.name("ClientMetadata");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> clientMetadataEntry : clientMetadata.entrySet()) {
                    String clientMetadataValue = clientMetadataEntry.getValue();
                    if (clientMetadataValue == null) continue;
                    jsonWriter.name(clientMetadataEntry.getKey());
                    jsonWriter.value(clientMetadataValue);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

