/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.CustomDomainConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateUserPoolDomainRequest;
import com.amazonaws.services.cognitoidentityprovider.model.transform.CustomDomainConfigTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateUserPoolDomainRequestMarshaller
implements Marshaller<Request<UpdateUserPoolDomainRequest>, UpdateUserPoolDomainRequest> {
    public Request<UpdateUserPoolDomainRequest> marshall(UpdateUserPoolDomainRequest updateUserPoolDomainRequest) {
        if (updateUserPoolDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateUserPoolDomainRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateUserPoolDomainRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.UpdateUserPoolDomain";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateUserPoolDomainRequest.getDomain() != null) {
                String domain = updateUserPoolDomainRequest.getDomain();
                jsonWriter.name("Domain");
                jsonWriter.value(domain);
            }
            if (updateUserPoolDomainRequest.getUserPoolId() != null) {
                String userPoolId = updateUserPoolDomainRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (updateUserPoolDomainRequest.getCustomDomainConfig() != null) {
                CustomDomainConfigType customDomainConfig = updateUserPoolDomainRequest.getCustomDomainConfig();
                jsonWriter.name("CustomDomainConfig");
                CustomDomainConfigTypeJsonMarshaller.getInstance().marshall(customDomainConfig, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

