/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AdminCreateUserConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.DeviceConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.EmailConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.LambdaConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.SmsConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateUserPoolRequest;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolAddOnsType;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolPolicyType;
import com.amazonaws.services.cognitoidentityprovider.model.VerificationMessageTemplateType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AdminCreateUserConfigTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.DeviceConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.EmailConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.LambdaConfigTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.SmsConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.UserPoolAddOnsTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.UserPoolPolicyTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.VerificationMessageTemplateTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class UpdateUserPoolRequestMarshaller
implements Marshaller<Request<UpdateUserPoolRequest>, UpdateUserPoolRequest> {
    public Request<UpdateUserPoolRequest> marshall(UpdateUserPoolRequest updateUserPoolRequest) {
        if (updateUserPoolRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateUserPoolRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateUserPoolRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.UpdateUserPool";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateUserPoolRequest.getUserPoolId() != null) {
                String userPoolId = updateUserPoolRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (updateUserPoolRequest.getPolicies() != null) {
                UserPoolPolicyType policies = updateUserPoolRequest.getPolicies();
                jsonWriter.name("Policies");
                UserPoolPolicyTypeJsonMarshaller.getInstance().marshall(policies, jsonWriter);
            }
            if (updateUserPoolRequest.getLambdaConfig() != null) {
                LambdaConfigType lambdaConfig = updateUserPoolRequest.getLambdaConfig();
                jsonWriter.name("LambdaConfig");
                LambdaConfigTypeJsonMarshaller.getInstance().marshall(lambdaConfig, jsonWriter);
            }
            if (updateUserPoolRequest.getAutoVerifiedAttributes() != null) {
                List<String> autoVerifiedAttributes = updateUserPoolRequest.getAutoVerifiedAttributes();
                jsonWriter.name("AutoVerifiedAttributes");
                jsonWriter.beginArray();
                for (String string : autoVerifiedAttributes) {
                    if (string == null) continue;
                    jsonWriter.value(string);
                }
                jsonWriter.endArray();
            }
            if (updateUserPoolRequest.getSmsVerificationMessage() != null) {
                String smsVerificationMessage = updateUserPoolRequest.getSmsVerificationMessage();
                jsonWriter.name("SmsVerificationMessage");
                jsonWriter.value(smsVerificationMessage);
            }
            if (updateUserPoolRequest.getEmailVerificationMessage() != null) {
                String emailVerificationMessage = updateUserPoolRequest.getEmailVerificationMessage();
                jsonWriter.name("EmailVerificationMessage");
                jsonWriter.value(emailVerificationMessage);
            }
            if (updateUserPoolRequest.getEmailVerificationSubject() != null) {
                String emailVerificationSubject = updateUserPoolRequest.getEmailVerificationSubject();
                jsonWriter.name("EmailVerificationSubject");
                jsonWriter.value(emailVerificationSubject);
            }
            if (updateUserPoolRequest.getVerificationMessageTemplate() != null) {
                VerificationMessageTemplateType verificationMessageTemplate = updateUserPoolRequest.getVerificationMessageTemplate();
                jsonWriter.name("VerificationMessageTemplate");
                VerificationMessageTemplateTypeJsonMarshaller.getInstance().marshall(verificationMessageTemplate, jsonWriter);
            }
            if (updateUserPoolRequest.getSmsAuthenticationMessage() != null) {
                String smsAuthenticationMessage = updateUserPoolRequest.getSmsAuthenticationMessage();
                jsonWriter.name("SmsAuthenticationMessage");
                jsonWriter.value(smsAuthenticationMessage);
            }
            if (updateUserPoolRequest.getMfaConfiguration() != null) {
                String mfaConfiguration = updateUserPoolRequest.getMfaConfiguration();
                jsonWriter.name("MfaConfiguration");
                jsonWriter.value(mfaConfiguration);
            }
            if (updateUserPoolRequest.getDeviceConfiguration() != null) {
                DeviceConfigurationType deviceConfiguration = updateUserPoolRequest.getDeviceConfiguration();
                jsonWriter.name("DeviceConfiguration");
                DeviceConfigurationTypeJsonMarshaller.getInstance().marshall(deviceConfiguration, jsonWriter);
            }
            if (updateUserPoolRequest.getEmailConfiguration() != null) {
                EmailConfigurationType emailConfiguration = updateUserPoolRequest.getEmailConfiguration();
                jsonWriter.name("EmailConfiguration");
                EmailConfigurationTypeJsonMarshaller.getInstance().marshall(emailConfiguration, jsonWriter);
            }
            if (updateUserPoolRequest.getSmsConfiguration() != null) {
                SmsConfigurationType smsConfiguration = updateUserPoolRequest.getSmsConfiguration();
                jsonWriter.name("SmsConfiguration");
                SmsConfigurationTypeJsonMarshaller.getInstance().marshall(smsConfiguration, jsonWriter);
            }
            if (updateUserPoolRequest.getUserPoolTags() != null) {
                Map<String, String> userPoolTags = updateUserPoolRequest.getUserPoolTags();
                jsonWriter.name("UserPoolTags");
                jsonWriter.beginObject();
                for (Map.Entry entry : userPoolTags.entrySet()) {
                    String userPoolTagsValue = (String)entry.getValue();
                    if (userPoolTagsValue == null) continue;
                    jsonWriter.name((String)entry.getKey());
                    jsonWriter.value(userPoolTagsValue);
                }
                jsonWriter.endObject();
            }
            if (updateUserPoolRequest.getAdminCreateUserConfig() != null) {
                AdminCreateUserConfigType adminCreateUserConfig = updateUserPoolRequest.getAdminCreateUserConfig();
                jsonWriter.name("AdminCreateUserConfig");
                AdminCreateUserConfigTypeJsonMarshaller.getInstance().marshall(adminCreateUserConfig, jsonWriter);
            }
            if (updateUserPoolRequest.getUserPoolAddOns() != null) {
                UserPoolAddOnsType userPoolAddOns = updateUserPoolRequest.getUserPoolAddOns();
                jsonWriter.name("UserPoolAddOns");
                UserPoolAddOnsTypeJsonMarshaller.getInstance().marshall(userPoolAddOns, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

