/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.services.cognitoidentityprovider.model.HttpHeader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContextDataType
implements Serializable {
    private String ipAddress;
    private String serverName;
    private String serverPath;
    private List<HttpHeader> httpHeaders;
    private String encodedData;

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public ContextDataType withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public ContextDataType withServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public void setServerPath(String serverPath) {
        this.serverPath = serverPath;
    }

    public ContextDataType withServerPath(String serverPath) {
        this.serverPath = serverPath;
        return this;
    }

    public List<HttpHeader> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Collection<HttpHeader> httpHeaders) {
        if (httpHeaders == null) {
            this.httpHeaders = null;
            return;
        }
        this.httpHeaders = new ArrayList<HttpHeader>(httpHeaders);
    }

    public ContextDataType withHttpHeaders(HttpHeader ... httpHeaders) {
        if (this.getHttpHeaders() == null) {
            this.httpHeaders = new ArrayList<HttpHeader>(httpHeaders.length);
        }
        for (HttpHeader value : httpHeaders) {
            this.httpHeaders.add(value);
        }
        return this;
    }

    public ContextDataType withHttpHeaders(Collection<HttpHeader> httpHeaders) {
        this.setHttpHeaders(httpHeaders);
        return this;
    }

    public String getEncodedData() {
        return this.encodedData;
    }

    public void setEncodedData(String encodedData) {
        this.encodedData = encodedData;
    }

    public ContextDataType withEncodedData(String encodedData) {
        this.encodedData = encodedData;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIpAddress() != null) {
            sb.append("IpAddress: " + this.getIpAddress() + ",");
        }
        if (this.getServerName() != null) {
            sb.append("ServerName: " + this.getServerName() + ",");
        }
        if (this.getServerPath() != null) {
            sb.append("ServerPath: " + this.getServerPath() + ",");
        }
        if (this.getHttpHeaders() != null) {
            sb.append("HttpHeaders: " + this.getHttpHeaders() + ",");
        }
        if (this.getEncodedData() != null) {
            sb.append("EncodedData: " + this.getEncodedData());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIpAddress() == null ? 0 : this.getIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getServerName() == null ? 0 : this.getServerName().hashCode());
        hashCode = 31 * hashCode + (this.getServerPath() == null ? 0 : this.getServerPath().hashCode());
        hashCode = 31 * hashCode + (this.getHttpHeaders() == null ? 0 : this.getHttpHeaders().hashCode());
        hashCode = 31 * hashCode + (this.getEncodedData() == null ? 0 : this.getEncodedData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextDataType)) {
            return false;
        }
        ContextDataType other = (ContextDataType)obj;
        if (other.getIpAddress() == null ^ this.getIpAddress() == null) {
            return false;
        }
        if (other.getIpAddress() != null && !other.getIpAddress().equals(this.getIpAddress())) {
            return false;
        }
        if (other.getServerName() == null ^ this.getServerName() == null) {
            return false;
        }
        if (other.getServerName() != null && !other.getServerName().equals(this.getServerName())) {
            return false;
        }
        if (other.getServerPath() == null ^ this.getServerPath() == null) {
            return false;
        }
        if (other.getServerPath() != null && !other.getServerPath().equals(this.getServerPath())) {
            return false;
        }
        if (other.getHttpHeaders() == null ^ this.getHttpHeaders() == null) {
            return false;
        }
        if (other.getHttpHeaders() != null && !other.getHttpHeaders().equals(this.getHttpHeaders())) {
            return false;
        }
        if (other.getEncodedData() == null ^ this.getEncodedData() == null) {
            return false;
        }
        return other.getEncodedData() == null || other.getEncodedData().equals(this.getEncodedData());
    }
}

