/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.cognito.clientcontext.util;

import android.util.Base64;
import android.util.Log;
import com.amazonaws.cognito.clientcontext.data.ConfigurationConstant;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignatureGenerator {
    private static final String TAG = "HMAC_SHA256_Signature";
    private static final String ALGORITHM = "HmacSHA256";

    public String getSignature(String data, String secret, String version) {
        String signature = "";
        try {
            Mac sha256Hmac = Mac.getInstance(ALGORITHM);
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(ConfigurationConstant.DEFAULT_CHARSET), ALGORITHM);
            sha256Hmac.init(secretKey);
            byte[] versionBytes = version.getBytes(ConfigurationConstant.DEFAULT_CHARSET);
            sha256Hmac.update(versionBytes);
            byte[] dataBytes = data.getBytes(ConfigurationConstant.DEFAULT_CHARSET);
            signature = Base64.encodeToString((byte[])sha256Hmac.doFinal(dataBytes), (int)0);
        }
        catch (Exception e) {
            this.logWarning(e);
        }
        return signature;
    }

    private void logWarning(Exception e) {
        Log.w((String)TAG, (String)"Exception while completing context data signature", (Throwable)e);
    }
}

