/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.cognito.clientcontext.datacollection;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.amazonaws.cognito.clientcontext.datacollection.DataCollector;
import java.util.HashMap;
import java.util.Map;

public class ApplicationDataCollector
extends DataCollector {
    private static final String TAG = ApplicationDataCollector.class.getSimpleName();
    private static final int ALL_FLAGS_OFF = 0;

    @Override
    public Map<String, String> collect(Context context) {
        HashMap<String, String> contextData = new HashMap<String, String>();
        contextData.put("ApplicationName", this.getAppName(context));
        contextData.put("ApplicationTargetSdk", this.getAppTargetSdk(context));
        contextData.put("ApplicationVersion", this.getAppVersion(context));
        return contextData;
    }

    private String getAppName(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        PackageManager packageManager = context.getPackageManager();
        String appName = (String)packageManager.getApplicationLabel(applicationInfo);
        return appName;
    }

    private String getAppVersion(Context context) {
        PackageManager packageManager = context.getPackageManager();
        String appVersion = "";
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            appVersion = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.i((String)TAG, (String)"Unable to get app version. Provided package name could not be found.");
        }
        return appVersion;
    }

    private String getAppTargetSdk(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        return String.valueOf(applicationInfo.targetSdkVersion);
    }
}

