/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListRecordsRequestMarshaller
implements Marshaller<Request<ListRecordsRequest>, ListRecordsRequest> {
    public Request<ListRecordsRequest> marshall(ListRecordsRequest listRecordsRequest) {
        if (listRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListRecordsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRecordsRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/records";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", listRecordsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replace("{IdentityId}", listRecordsRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getIdentityId()));
        uriResourcePath = uriResourcePath.replace("{DatasetName}", listRecordsRequest.getDatasetName() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getDatasetName()));
        if (listRecordsRequest.getLastSyncCount() != null) {
            request.addParameter("lastSyncCount", StringUtils.fromLong((Long)listRecordsRequest.getLastSyncCount()));
        }
        if (listRecordsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listRecordsRequest.getNextToken()));
        }
        if (listRecordsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listRecordsRequest.getMaxResults()));
        }
        if (listRecordsRequest.getSyncSessionToken() != null) {
            request.addParameter("syncSessionToken", StringUtils.fromString((String)listRecordsRequest.getSyncSessionToken()));
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

