/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListRecordsRequestMarshaller
implements Marshaller<Request<ListRecordsRequest>, ListRecordsRequest> {
    public Request<ListRecordsRequest> marshall(ListRecordsRequest listRecordsRequest) {
        if (listRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRecordsRequest, "AmazonCognitoSync");
        String target = "AWSCognitoSyncService.ListRecords";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/records?lastSyncCount={LastSyncCount};maxResults={MaxResults};nextToken={NextToken};syncSessionToken={SyncSessionToken}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", listRecordsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replace("{IdentityId}", listRecordsRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getIdentityId()));
        uriResourcePath = uriResourcePath.replace("{DatasetName}", listRecordsRequest.getDatasetName() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getDatasetName()));
        uriResourcePath = uriResourcePath.replace("{LastSyncCount}", listRecordsRequest.getLastSyncCount() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getLastSyncCount()));
        uriResourcePath = uriResourcePath.replace("{NextToken}", listRecordsRequest.getNextToken() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getNextToken()));
        uriResourcePath = uriResourcePath.replace("{MaxResults}", listRecordsRequest.getMaxResults() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getMaxResults()));
        uriResourcePath = uriResourcePath.replace("{SyncSessionToken}", listRecordsRequest.getSyncSessionToken() == null ? "" : StringUtils.fromString((String)listRecordsRequest.getSyncSessionToken()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

