/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListDatasetsRequestMarshaller
implements Marshaller<Request<ListDatasetsRequest>, ListDatasetsRequest> {
    public Request<ListDatasetsRequest> marshall(ListDatasetsRequest listDatasetsRequest) {
        if (listDatasetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listDatasetsRequest, "AmazonCognitoSync");
        String target = "AWSCognitoSyncService.ListDatasets";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets?maxResults={MaxResults};nextToken={NextToken}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", listDatasetsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)listDatasetsRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replace("{IdentityId}", listDatasetsRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)listDatasetsRequest.getIdentityId()));
        uriResourcePath = uriResourcePath.replace("{NextToken}", listDatasetsRequest.getNextToken() == null ? "" : StringUtils.fromString((String)listDatasetsRequest.getNextToken()));
        uriResourcePath = uriResourcePath.replace("{MaxResults}", listDatasetsRequest.getMaxResults() == null ? "" : StringUtils.fromString((String)listDatasetsRequest.getMaxResults()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.addHeader("Content-Length", "0");
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

