/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.services.cognitosync.model.Record;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;

public class RecordJsonUnmarshaller
implements Unmarshaller<Record, JsonUnmarshallerContext> {
    private static RecordJsonUnmarshaller instance;

    public Record unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
        Record record = new Record();
        int n = jsonUnmarshallerContext.getCurrentDepth();
        String string = jsonUnmarshallerContext.getCurrentParentElement();
        int n2 = n + 1;
        JsonToken jsonToken = jsonUnmarshallerContext.currentToken;
        if (jsonToken == null) {
            jsonToken = jsonUnmarshallerContext.nextToken();
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        while (jsonToken != null) {
            if (jsonToken == JsonToken.FIELD_NAME || jsonToken == JsonToken.START_OBJECT) {
                if (jsonUnmarshallerContext.testExpression("Key", n2)) {
                    jsonUnmarshallerContext.nextToken();
                    record.setKey(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(jsonUnmarshallerContext));
                }
                if (jsonUnmarshallerContext.testExpression("Value", n2)) {
                    jsonUnmarshallerContext.nextToken();
                    record.setValue(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(jsonUnmarshallerContext));
                }
                if (jsonUnmarshallerContext.testExpression("SyncCount", n2)) {
                    jsonUnmarshallerContext.nextToken();
                    record.setSyncCount(SimpleTypeJsonUnmarshallers.LongJsonUnmarshaller.getInstance().unmarshall(jsonUnmarshallerContext));
                }
                if (jsonUnmarshallerContext.testExpression("LastModifiedDate", n2)) {
                    jsonUnmarshallerContext.nextToken();
                    record.setLastModifiedDate(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(jsonUnmarshallerContext));
                }
                if (jsonUnmarshallerContext.testExpression("LastModifiedBy", n2)) {
                    jsonUnmarshallerContext.nextToken();
                    record.setLastModifiedBy(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(jsonUnmarshallerContext));
                }
                if (jsonUnmarshallerContext.testExpression("DeviceLastModifiedDate", n2)) {
                    jsonUnmarshallerContext.nextToken();
                    record.setDeviceLastModifiedDate(SimpleTypeJsonUnmarshallers.DateJsonUnmarshaller.getInstance().unmarshall(jsonUnmarshallerContext));
                }
            } else if (!(jsonToken != JsonToken.END_ARRAY && jsonToken != JsonToken.END_OBJECT || jsonUnmarshallerContext.getLastParsedParentElement() != null && !jsonUnmarshallerContext.getLastParsedParentElement().equals(string) || jsonUnmarshallerContext.getCurrentDepth() > n)) break;
            jsonToken = jsonUnmarshallerContext.nextToken();
        }
        return record;
    }

    public static RecordJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RecordJsonUnmarshaller();
        }
        return instance;
    }
}

