/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito.internal.storage;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.mobileconnectors.cognito.DatasetMetadata;
import com.amazonaws.mobileconnectors.cognito.Record;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataAccessNotAuthorizedException;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataConflictException;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataLimitExceededException;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataStorageException;
import com.amazonaws.mobileconnectors.cognito.exceptions.DatasetNotFoundException;
import com.amazonaws.mobileconnectors.cognito.exceptions.NetworkException;
import com.amazonaws.mobileconnectors.cognito.internal.storage.RemoteDataStorage;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentity.model.NotAuthorizedException;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncClient;
import com.amazonaws.services.cognitosync.model.Dataset;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.services.cognitosync.model.DescribeDatasetRequest;
import com.amazonaws.services.cognitosync.model.DescribeDatasetResult;
import com.amazonaws.services.cognitosync.model.LimitExceededException;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.services.cognitosync.model.ListDatasetsResult;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.services.cognitosync.model.ListRecordsResult;
import com.amazonaws.services.cognitosync.model.Operation;
import com.amazonaws.services.cognitosync.model.RecordPatch;
import com.amazonaws.services.cognitosync.model.ResourceConflictException;
import com.amazonaws.services.cognitosync.model.ResourceNotFoundException;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.services.cognitosync.model.UpdateRecordsResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CognitoSyncStorage
implements RemoteDataStorage {
    private final String identityPoolId;
    private final AmazonCognitoSyncClient client;
    private final CognitoCachingCredentialsProvider provider;
    private String userAgent;

    public CognitoSyncStorage(String string, Regions regions, CognitoCachingCredentialsProvider cognitoCachingCredentialsProvider) {
        this.identityPoolId = string;
        this.provider = cognitoCachingCredentialsProvider;
        this.client = new AmazonCognitoSyncClient((AWSCredentialsProvider)cognitoCachingCredentialsProvider);
        this.client.setRegion(Region.getRegion((Regions)regions));
        this.userAgent = "";
    }

    @Override
    public List<DatasetMetadata> getDatasets() {
        ListDatasetsResult listDatasetsResult;
        ArrayList<DatasetMetadata> arrayList = new ArrayList<DatasetMetadata>();
        String string = null;
        do {
            ListDatasetsRequest listDatasetsRequest = new ListDatasetsRequest();
            this.appendUserAgent(listDatasetsRequest, this.userAgent);
            listDatasetsRequest.setIdentityPoolId(this.identityPoolId);
            listDatasetsRequest.setMaxResults("64");
            listDatasetsRequest.setNextToken(string);
            listDatasetsResult = null;
            try {
                listDatasetsRequest.setIdentityId(this.getIdentityId());
                listDatasetsResult = this.client.listDatasets(listDatasetsRequest);
            }
            catch (AmazonClientException amazonClientException) {
                throw this.handleException(amazonClientException, "Failed to list dataset metadata");
            }
            for (Dataset dataset : listDatasetsResult.getDatasets()) {
                arrayList.add(this.modelToDatasetMetadata(dataset));
            }
        } while ((string = listDatasetsResult.getNextToken()) != null);
        return arrayList;
    }

    @Override
    public RemoteDataStorage.DatasetUpdates listUpdates(String string, long l) {
        ListRecordsResult listRecordsResult;
        DatasetUpdatesImpl.Builder builder = new DatasetUpdatesImpl.Builder(string);
        String string2 = null;
        do {
            ListRecordsRequest listRecordsRequest = new ListRecordsRequest();
            this.appendUserAgent(listRecordsRequest, this.userAgent);
            listRecordsRequest.setIdentityPoolId(this.identityPoolId);
            listRecordsRequest.setDatasetName(string);
            listRecordsRequest.setLastSyncCount(String.valueOf(l));
            listRecordsRequest.setMaxResults("1024");
            listRecordsRequest.setNextToken(string2);
            listRecordsResult = null;
            try {
                listRecordsRequest.setIdentityId(this.getIdentityId());
                listRecordsResult = this.client.listRecords(listRecordsRequest);
            }
            catch (AmazonClientException amazonClientException) {
                throw this.handleException(amazonClientException, "Failed to list records in dataset: " + string);
            }
            for (com.amazonaws.services.cognitosync.model.Record record : listRecordsResult.getRecords()) {
                builder.addRecord(this.modelToRecord(record));
            }
            builder.syncSessionToken(listRecordsResult.getSyncSessionToken()).syncCount(listRecordsResult.getDatasetSyncCount()).exists(listRecordsResult.isDatasetExists()).deleted(listRecordsResult.isDatasetDeletedAfterRequestedSyncCount()).mergedDatasetNameList(listRecordsResult.getMergedDatasetNames());
        } while ((string2 = listRecordsResult.getNextToken()) != null);
        return builder.build();
    }

    @Override
    public List<Record> putRecords(String string, List<Record> list, String string2) {
        UpdateRecordsRequest updateRecordsRequest = new UpdateRecordsRequest();
        this.appendUserAgent(updateRecordsRequest, this.userAgent);
        updateRecordsRequest.setDatasetName(string);
        updateRecordsRequest.setIdentityPoolId(this.identityPoolId);
        updateRecordsRequest.setSyncSessionToken(string2);
        ArrayList<RecordPatch> arrayList = new ArrayList<RecordPatch>();
        for (Record object : list) {
            arrayList.add(this.recordToPatch(object));
        }
        updateRecordsRequest.setRecordPatches(arrayList);
        ArrayList arrayList2 = new ArrayList();
        try {
            updateRecordsRequest.setIdentityId(this.getIdentityId());
            UpdateRecordsResult amazonClientException = this.client.updateRecords(updateRecordsRequest);
            for (com.amazonaws.services.cognitosync.model.Record record : amazonClientException.getRecords()) {
                arrayList2.add(this.modelToRecord(record));
            }
        }
        catch (AmazonClientException amazonClientException) {
            throw this.handleException(amazonClientException, "Failed to update records in dataset: " + string);
        }
        return arrayList2;
    }

    @Override
    public void deleteDataset(String string) {
        DeleteDatasetRequest deleteDatasetRequest = new DeleteDatasetRequest();
        this.appendUserAgent(deleteDatasetRequest, this.userAgent);
        deleteDatasetRequest.setIdentityPoolId(this.identityPoolId);
        deleteDatasetRequest.setDatasetName(string);
        try {
            deleteDatasetRequest.setIdentityId(this.getIdentityId());
            this.client.deleteDataset(deleteDatasetRequest);
        }
        catch (AmazonClientException amazonClientException) {
            throw this.handleException(amazonClientException, "Failed to delete dataset: " + string);
        }
    }

    RecordPatch recordToPatch(Record record) {
        RecordPatch recordPatch = new RecordPatch();
        recordPatch.setKey(record.getKey());
        recordPatch.setValue(record.getValue());
        recordPatch.setSyncCount(record.getSyncCount());
        recordPatch.setOp(record.getValue() == null ? Operation.Remove : Operation.Replace);
        if (record.getDeviceLastModifiedDate() != null) {
            recordPatch.setDeviceLastModifiedDate(record.getDeviceLastModifiedDate());
        }
        return recordPatch;
    }

    Record modelToRecord(com.amazonaws.services.cognitosync.model.Record record) {
        return new Record.Builder(record.getKey()).value(record.getValue()).syncCount(record.getSyncCount() == null ? 0L : record.getSyncCount()).lastModifiedBy(record.getLastModifiedBy()).lastModifiedDate(record.getLastModifiedDate() == null ? new Date(0L) : record.getLastModifiedDate()).deviceLastModifiedDate(record.getDeviceLastModifiedDate() == null ? new Date(0L) : record.getDeviceLastModifiedDate()).build();
    }

    @Override
    public DatasetMetadata getDatasetMetadata(String string) throws DataStorageException {
        DescribeDatasetRequest describeDatasetRequest = new DescribeDatasetRequest();
        this.appendUserAgent(describeDatasetRequest, this.userAgent);
        describeDatasetRequest.setIdentityPoolId(this.identityPoolId);
        DatasetMetadata datasetMetadata = null;
        try {
            describeDatasetRequest.setIdentityId(this.getIdentityId());
            describeDatasetRequest.setDatasetName(string);
            DescribeDatasetResult describeDatasetResult = this.client.describeDataset(describeDatasetRequest);
            datasetMetadata = this.modelToDatasetMetadata(describeDatasetResult.getDataset());
        }
        catch (AmazonClientException amazonClientException) {
            throw this.handleException(amazonClientException, "Failed to get metadata of dataset: " + string);
        }
        return datasetMetadata;
    }

    DataStorageException handleException(AmazonClientException amazonClientException, String string) {
        if (amazonClientException instanceof ResourceNotFoundException) {
            return new DatasetNotFoundException(string);
        }
        if (amazonClientException instanceof ResourceConflictException) {
            return new DataConflictException(string);
        }
        if (amazonClientException instanceof LimitExceededException) {
            return new DataLimitExceededException(string);
        }
        if (amazonClientException instanceof NotAuthorizedException) {
            return new DataAccessNotAuthorizedException(string);
        }
        if (this.isNetworkException(amazonClientException)) {
            return new NetworkException(string);
        }
        return new DataStorageException(string, amazonClientException);
    }

    String getIdentityId() throws AmazonClientException, NotAuthorizedException {
        return this.provider.getIdentityId();
    }

    boolean isNetworkException(AmazonClientException amazonClientException) {
        return amazonClientException.getCause() instanceof IOException;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    void appendUserAgent(AmazonWebServiceRequest amazonWebServiceRequest, String string) {
        amazonWebServiceRequest.getRequestClientOptions().appendUserAgent(string);
    }

    private DatasetMetadata modelToDatasetMetadata(Dataset dataset) {
        return new DatasetMetadata.Builder(dataset.getDatasetName()).creationDate(dataset.getCreationDate()).lastModifiedDate(dataset.getLastModifiedDate()).lastModifiedBy(dataset.getLastModifiedBy()).storageSizeBytes(dataset.getDataStorage()).recordCount(dataset.getNumRecords()).build();
    }

    static class DatasetUpdatesImpl
    implements RemoteDataStorage.DatasetUpdates {
        private final String datasetName;
        private final List<Record> records;
        private final long syncCount;
        private final String syncSessionToken;
        private final boolean exists;
        private final boolean deleted;
        private final List<String> mergedDatasetNameList;

        @Override
        public String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public List<Record> getRecords() {
            return this.records;
        }

        @Override
        public long getSyncCount() {
            return this.syncCount;
        }

        @Override
        public String getSyncSessionToken() {
            return this.syncSessionToken;
        }

        @Override
        public boolean isExists() {
            return this.exists;
        }

        @Override
        public boolean isDeleted() {
            return this.deleted;
        }

        @Override
        public List<String> getMergedDatasetNameList() {
            return this.mergedDatasetNameList;
        }

        private DatasetUpdatesImpl(Builder builder) {
            this.datasetName = builder.datasetName;
            this.records = builder.records;
            this.syncCount = builder.syncCount;
            this.syncSessionToken = builder.syncSessionToken;
            this.exists = builder.exists;
            this.deleted = builder.deleted;
            this.mergedDatasetNameList = builder.mergedDatasetNameList;
        }

        static class Builder {
            private final String datasetName;
            private final List<Record> records = new ArrayList<Record>();
            private long syncCount = 0L;
            private String syncSessionToken;
            private boolean exists = true;
            private boolean deleted = false;
            private final List<String> mergedDatasetNameList = new ArrayList<String>();

            Builder(String string) {
                this.datasetName = string;
            }

            Builder syncSessionToken(String string) {
                this.syncSessionToken = string;
                return this;
            }

            Builder syncCount(long l) {
                this.syncCount = l;
                return this;
            }

            Builder exists(boolean bl) {
                this.exists = bl;
                return this;
            }

            Builder deleted(boolean bl) {
                this.deleted = bl;
                return this;
            }

            Builder addRecord(Record record) {
                this.records.add(record);
                return this;
            }

            Builder mergedDatasetNameList(List<String> list) {
                this.mergedDatasetNameList.addAll(list);
                return this;
            }

            RemoteDataStorage.DatasetUpdates build() {
                return new DatasetUpdatesImpl(this);
            }
        }
    }
}

