/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.core.signin.ui;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;

public class SplitBackgroundDrawable
extends Drawable {
    private Paint paint = new Paint();
    private int distanceFromTopToSplitPoint = -1;
    private int topBackgroundColor;
    private static final int DEFAULT_BACKGROUND_COLOR = -1;

    public SplitBackgroundDrawable(int distanceFromTop) {
        this.topBackgroundColor = -1;
        this.setSplitPointDistanceFromTop(distanceFromTop);
    }

    public SplitBackgroundDrawable(int distanceFromTop, int topBackgroundColor) {
        this.topBackgroundColor = topBackgroundColor;
        this.setSplitPointDistanceFromTop(distanceFromTop);
    }

    public void setSplitPointDistanceFromTop(int distanceFromTop) {
        this.distanceFromTopToSplitPoint = distanceFromTop;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        Rect b = this.getBounds();
        this.paint.setColor(this.topBackgroundColor);
        float y = this.distanceFromTopToSplitPoint < b.height() ? (float)this.distanceFromTopToSplitPoint : (float)b.height();
        canvas.drawRect(0.0f, 0.0f, (float)b.width(), y, this.paint);
        this.paint.setColor(-1);
        canvas.drawRect(0.0f, y, (float)b.width(), (float)b.height(), this.paint);
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }
}

