/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.core;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.auth.AWSBasicCognitoIdentityProvider;
import com.amazonaws.auth.AWSCognitoIdentityProvider;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.internal.keyvaluestore.AWSKeyValueStore;
import com.amazonaws.mobile.auth.core.IdentityHandler;
import com.amazonaws.mobile.auth.core.IdentityProvider;
import com.amazonaws.mobile.auth.core.SignInResultHandler;
import com.amazonaws.mobile.auth.core.SignInStateChangeListener;
import com.amazonaws.mobile.auth.core.StartupAuthErrorDetails;
import com.amazonaws.mobile.auth.core.StartupAuthResult;
import com.amazonaws.mobile.auth.core.StartupAuthResultHandler;
import com.amazonaws.mobile.auth.core.internal.util.ThreadUtils;
import com.amazonaws.mobile.auth.core.signin.AuthException;
import com.amazonaws.mobile.auth.core.signin.CognitoAuthException;
import com.amazonaws.mobile.auth.core.signin.ProviderAuthException;
import com.amazonaws.mobile.auth.core.signin.SignInManager;
import com.amazonaws.mobile.auth.core.signin.SignInProvider;
import com.amazonaws.mobile.auth.core.signin.SignInProviderResultHandler;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class IdentityManager {
    private static final String LOG_TAG = IdentityManager.class.getSimpleName();
    private static final String AWS_CONFIGURATION_FILE = "awsconfiguration.json";
    private final AWSCredentialsProviderHolder credentialsProviderHolder;
    private final Context appContext;
    private AWSConfiguration awsConfiguration;
    private final ClientConfiguration clientConfiguration;
    private final ExecutorService executorService = Executors.newFixedThreadPool(4);
    private final CountDownLatch startupAuthTimeoutLatch = new CountDownLatch(1);
    private final Set<Class<? extends SignInProvider>> signInProviderClasses = new HashSet<Class<? extends SignInProvider>>();
    private volatile IdentityProvider currentIdentityProvider = null;
    private SignInProviderResultAdapter resultsAdapter;
    private final HashSet<SignInStateChangeListener> signInStateChangeListeners = new HashSet();
    private static IdentityManager defaultIdentityManager = null;
    private static final String SHARED_PREF_NAME = "com.amazonaws.android.auth";
    private static final String EXPIRATION_KEY = "expirationDate";
    private AWSKeyValueStore awsKeyValueStore;
    private boolean isPersistenceEnabled = true;
    boolean shouldFederate = true;

    public IdentityManager(Context context) {
        this.appContext = context.getApplicationContext();
        this.awsConfiguration = null;
        this.clientConfiguration = null;
        this.credentialsProviderHolder = null;
        this.awsKeyValueStore = new AWSKeyValueStore(this.appContext, SHARED_PREF_NAME, this.isPersistenceEnabled);
    }

    public IdentityManager(Context context, AWSConfiguration awsConfiguration) {
        this.appContext = context.getApplicationContext();
        this.awsConfiguration = awsConfiguration;
        this.clientConfiguration = new ClientConfiguration().withUserAgent(awsConfiguration.getUserAgent()).withUserAgentOverride(awsConfiguration.getUserAgentOverride());
        this.credentialsProviderHolder = new AWSCredentialsProviderHolder();
        this.createCredentialsProvider(this.appContext, this.clientConfiguration);
        this.awsKeyValueStore = new AWSKeyValueStore(this.appContext, SHARED_PREF_NAME, this.isPersistenceEnabled);
    }

    public IdentityManager(Context context, AWSConfiguration awsConfiguration, ClientConfiguration clientConfiguration) {
        this.appContext = context.getApplicationContext();
        this.awsConfiguration = awsConfiguration;
        this.clientConfiguration = clientConfiguration;
        String userAgent = this.awsConfiguration.getUserAgent();
        String currentUserAgent = this.clientConfiguration.getUserAgent();
        String string = currentUserAgent = currentUserAgent != null ? currentUserAgent : "";
        if (userAgent != null && userAgent != currentUserAgent) {
            this.clientConfiguration.setUserAgent(currentUserAgent.trim() + " " + userAgent);
        }
        this.credentialsProviderHolder = new AWSCredentialsProviderHolder();
        this.createCredentialsProvider(this.appContext, this.clientConfiguration);
        this.awsKeyValueStore = new AWSKeyValueStore(this.appContext, SHARED_PREF_NAME, this.isPersistenceEnabled);
    }

    public IdentityManager(Context context, CognitoCachingCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this.appContext = context.getApplicationContext();
        this.clientConfiguration = clientConfiguration;
        this.credentialsProviderHolder = new AWSCredentialsProviderHolder();
        this.credentialsProviderHolder.setUnderlyingProvider(credentialsProvider);
        this.awsKeyValueStore = new AWSKeyValueStore(this.appContext, SHARED_PREF_NAME, this.isPersistenceEnabled);
    }

    public void setPersistenceEnabled(boolean persistenceEnabled) {
        this.isPersistenceEnabled = persistenceEnabled;
        this.awsKeyValueStore.setPersistenceEnabled(this.isPersistenceEnabled);
    }

    public void enableFederation(boolean enabled) {
        this.shouldFederate = enabled;
    }

    public static IdentityManager getDefaultIdentityManager() {
        return defaultIdentityManager;
    }

    public static void setDefaultIdentityManager(IdentityManager identityManager) {
        defaultIdentityManager = null;
        defaultIdentityManager = identityManager;
    }

    public AWSConfiguration getConfiguration() {
        return this.awsConfiguration;
    }

    public void setConfiguration(AWSConfiguration configuration) {
        this.awsConfiguration = configuration;
    }

    public boolean areCredentialsExpired() {
        if (!this.shouldFederate) {
            throw new IllegalStateException("Federation is not enabled and does not support credentials");
        }
        Date credentialsExpirationDate = this.credentialsProviderHolder.getUnderlyingProvider().getSessionCredentialsExpiration();
        if (credentialsExpirationDate == null) {
            Log.d((String)LOG_TAG, (String)"Credentials are EXPIRED.");
            return true;
        }
        long currentTime = System.currentTimeMillis() - (long)(SDKGlobalConfiguration.getGlobalTimeOffset() * 1000);
        boolean credsAreExpired = credentialsExpirationDate.getTime() - currentTime < 0L;
        Log.d((String)LOG_TAG, (String)("Credentials are " + (credsAreExpired ? "EXPIRED." : "OK")));
        return credsAreExpired;
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        return this.credentialsProviderHolder;
    }

    public CognitoCachingCredentialsProvider getUnderlyingProvider() {
        return this.credentialsProviderHolder.getUnderlyingProvider();
    }

    public String getCachedUserID() {
        if (!this.shouldFederate) {
            throw new IllegalStateException("Federation is not enabled and does not support user id");
        }
        return this.credentialsProviderHolder.getUnderlyingProvider().getCachedIdentityId();
    }

    public void getUserID(final IdentityHandler handler) {
        if (!this.shouldFederate) {
            throw new IllegalStateException("Federation is not enabled and does not support user id");
        }
        this.executorService.submit(new Runnable(){
            Exception exception = null;

            @Override
            public void run() {
                String result;
                String identityId = null;
                try {
                    result = identityId = IdentityManager.this.credentialsProviderHolder.getUnderlyingProvider().getIdentityId();
                }
                catch (Exception exception) {
                    String result2;
                    try {
                        this.exception = exception;
                        Log.e((String)LOG_TAG, (String)exception.getMessage(), (Throwable)exception);
                        result2 = identityId;
                    }
                    catch (Throwable throwable) {
                        String result3 = identityId;
                        Log.d((String)LOG_TAG, (String)("Got Amazon Cognito Federated Identity ID: " + identityId));
                        if (handler != null) {
                            ThreadUtils.runOnUiThread(new Runnable(result3){
                                final /* synthetic */ String val$result;
                                {
                                    this.val$result = string;
                                }

                                @Override
                                public void run() {
                                    if (exception != null) {
                                        handler.handleError(exception);
                                    } else {
                                        handler.onIdentityId(this.val$result);
                                    }
                                }
                            });
                        }
                        throw throwable;
                    }
                    Log.d((String)LOG_TAG, (String)("Got Amazon Cognito Federated Identity ID: " + identityId));
                    if (handler != null) {
                        ThreadUtils.runOnUiThread(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                Log.d((String)LOG_TAG, (String)("Got Amazon Cognito Federated Identity ID: " + identityId));
                if (handler != null) {
                    ThreadUtils.runOnUiThread(new /* invalid duplicate definition of identical inner class */);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSignInStateChangeListener(SignInStateChangeListener listener) {
        HashSet<SignInStateChangeListener> hashSet = this.signInStateChangeListeners;
        synchronized (hashSet) {
            this.signInStateChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSignInStateChangeListener(SignInStateChangeListener listener) {
        HashSet<SignInStateChangeListener> hashSet = this.signInStateChangeListeners;
        synchronized (hashSet) {
            this.signInStateChangeListeners.remove(listener);
        }
    }

    public SignInProviderResultAdapter getResultsAdapter() {
        return this.resultsAdapter;
    }

    public void signOut() {
        Log.d((String)LOG_TAG, (String)"Signing out...");
        if (this.currentIdentityProvider != null) {
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IdentityManager.this.currentIdentityProvider.signOut();
                    if (IdentityManager.this.shouldFederate) {
                        IdentityManager.this.credentialsProviderHolder.getUnderlyingProvider().clear();
                    }
                    IdentityManager.this.currentIdentityProvider = null;
                    HashSet hashSet = IdentityManager.this.signInStateChangeListeners;
                    synchronized (hashSet) {
                        for (SignInStateChangeListener listener : IdentityManager.this.signInStateChangeListeners) {
                            listener.onUserSignedOut();
                        }
                    }
                }
            });
        }
    }

    private void refreshCredentialWithLogins(Map<String, String> loginMap) {
        CognitoCachingCredentialsProvider credentialsProvider = this.credentialsProviderHolder.getUnderlyingProvider();
        if (!this.shouldFederate) {
            return;
        }
        credentialsProvider.clear();
        credentialsProvider.withLogins(loginMap);
        Log.d((String)LOG_TAG, (String)"refresh credentials");
        credentialsProvider.refresh();
        this.awsKeyValueStore.put(credentialsProvider.getIdentityPoolId() + "." + EXPIRATION_KEY, String.valueOf(System.currentTimeMillis() + 510000L));
    }

    public void setProviderResultsHandler(SignInProviderResultHandler signInProviderResultHandler) {
        if (signInProviderResultHandler == null) {
            throw new IllegalArgumentException("signInProviderResultHandler cannot be null.");
        }
        this.resultsAdapter = new SignInProviderResultAdapter(signInProviderResultHandler);
    }

    public void federateWithProvider(IdentityProvider provider) {
        Log.d((String)LOG_TAG, (String)"federate with provider: Populate loginsMap with token.");
        final HashMap<String, String> loginMap = new HashMap<String, String>();
        loginMap.put(provider.getCognitoLoginKey(), provider.getToken());
        this.currentIdentityProvider = provider;
        this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (IdentityManager.this.shouldFederate) {
                        IdentityManager.this.refreshCredentialWithLogins(loginMap);
                    }
                }
                catch (Exception ex) {
                    IdentityManager.this.resultsAdapter.onCognitoError(ex);
                    return;
                }
                IdentityManager.this.resultsAdapter.onCognitoSuccess();
                HashSet hashSet = IdentityManager.this.signInStateChangeListeners;
                synchronized (hashSet) {
                    for (SignInStateChangeListener listener : IdentityManager.this.signInStateChangeListeners) {
                        listener.onUserSignedIn();
                    }
                }
            }
        });
    }

    public IdentityProvider getCurrentIdentityProvider() {
        return this.currentIdentityProvider;
    }

    public void addSignInProvider(Class<? extends SignInProvider> providerClass) {
        this.signInProviderClasses.add(providerClass);
    }

    public Collection<Class<? extends SignInProvider>> getSignInProviderClasses() {
        return this.signInProviderClasses;
    }

    public boolean isUserSignedIn() {
        Map logins = this.credentialsProviderHolder.getUnderlyingProvider().getLogins();
        return logins != null && logins.size() != 0;
    }

    private void completeHandler(Activity callingActivity, final StartupAuthResultHandler startupAuthResultHandler, final AuthException ex) {
        this.runAfterStartupAuthDelay(callingActivity, new Runnable(){

            @Override
            public void run() {
                startupAuthResultHandler.onComplete(new StartupAuthResult(IdentityManager.this, new StartupAuthErrorDetails(ex, null)));
            }
        });
    }

    private void runAfterStartupAuthDelay(final Activity callingActivity, final Runnable runnable) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    IdentityManager.this.startupAuthTimeoutLatch.await();
                }
                catch (InterruptedException e) {
                    Log.d((String)LOG_TAG, (String)"Interrupted while waiting for startup auth minimum delay.");
                }
                callingActivity.runOnUiThread(runnable);
            }
        });
    }

    public void resumeSession(final Activity callingActivity, final StartupAuthResultHandler startupAuthResultHandler, final long minimumDelay) {
        Log.d((String)LOG_TAG, (String)"Resume Session called.");
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                Log.d((String)LOG_TAG, (String)"Looking for a previously signed-in session.");
                SignInManager signInManager = SignInManager.getInstance(callingActivity.getApplicationContext());
                SignInProvider signInProvider = signInManager.getPreviouslySignedInProvider();
                if (signInProvider != null) {
                    Log.d((String)LOG_TAG, (String)("Refreshing credentials with sign-in provider " + signInProvider.getDisplayName()));
                    signInManager.refreshCredentialsWithProvider(callingActivity, signInProvider, new SignInProviderResultHandler(){

                        @Override
                        public void onSuccess(IdentityProvider provider) {
                            Log.d((String)LOG_TAG, (String)"Successfully got AWS Credentials.");
                            IdentityManager.this.runAfterStartupAuthDelay(callingActivity, new Runnable(){

                                @Override
                                public void run() {
                                    startupAuthResultHandler.onComplete(new StartupAuthResult(IdentityManager.this, null));
                                }
                            });
                        }

                        @Override
                        public void onCancel(IdentityProvider provider) {
                            Log.wtf((String)LOG_TAG, (String)"Cancel can't happen when handling a previously signed-in user.");
                        }

                        @Override
                        public void onError(IdentityProvider provider, Exception ex) {
                            Log.e((String)LOG_TAG, (String)String.format("Federate with Cognito with %s Sign-in provider failed. Error: %s", provider.getDisplayName(), ex.getMessage()), (Throwable)ex);
                            if (ex instanceof AuthException) {
                                IdentityManager.this.completeHandler(callingActivity, startupAuthResultHandler, (AuthException)ex);
                            } else {
                                IdentityManager.this.completeHandler(callingActivity, startupAuthResultHandler, new AuthException(provider, ex));
                            }
                        }
                    });
                } else {
                    IdentityManager.this.completeHandler(callingActivity, startupAuthResultHandler, null);
                }
                if (minimumDelay > 0L) {
                    try {
                        Thread.sleep(minimumDelay);
                    }
                    catch (InterruptedException ex) {
                        Log.i((String)LOG_TAG, (String)"Interrupted while waiting for resume session timeout.");
                    }
                }
                IdentityManager.this.startupAuthTimeoutLatch.countDown();
            }
        });
    }

    public void resumeSession(Activity callingActivity, StartupAuthResultHandler startupAuthResultHandler) {
        this.resumeSession(callingActivity, startupAuthResultHandler, 0L);
    }

    @Deprecated
    public void doStartupAuth(Activity callingActivity, StartupAuthResultHandler startupAuthResultHandler) {
        this.resumeSession(callingActivity, startupAuthResultHandler, 0L);
    }

    @Deprecated
    public void doStartupAuth(Activity callingActivity, StartupAuthResultHandler startupAuthResultHandler, long minimumDelay) {
        this.resumeSession(callingActivity, startupAuthResultHandler, minimumDelay);
    }

    public void expireSignInTimeout() {
        this.startupAuthTimeoutLatch.countDown();
    }

    @Deprecated
    public void setUpToAuthenticate(Context context, SignInResultHandler signInResultHandler) {
        this.login(context, signInResultHandler);
    }

    public void login(Context context, SignInResultHandler signInResultHandler) {
        try {
            SignInManager.getInstance(context.getApplicationContext()).setResultHandler(signInResultHandler);
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Error in instantiating SignInManager. Check the context and completion handler.", (Throwable)exception);
        }
    }

    private void createCredentialsProvider(Context context, ClientConfiguration clientConfiguration) {
        String poolId;
        String region;
        Log.d((String)LOG_TAG, (String)"Creating the Cognito Caching Credentials Provider with a refreshing Cognito Identity Provider.");
        if (!this.shouldFederate) {
            return;
        }
        JSONObject cognitoIdentityConfig = this.getCognitoIdentityPoolConfig();
        try {
            region = cognitoIdentityConfig.getString("Region");
            poolId = cognitoIdentityConfig.getString("PoolId");
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Failed to read configuration for CognitoIdentity", e);
        }
        Regions cognitoIdentityRegion = Regions.fromName((String)region);
        AWSRefreshingCognitoIdentityProvider refreshingCredentialsProvider = new AWSRefreshingCognitoIdentityProvider(null, poolId, clientConfiguration, cognitoIdentityRegion);
        CognitoCachingCredentialsProvider cognitoCachingCredentialsProvider = new CognitoCachingCredentialsProvider(context, (AWSCognitoIdentityProvider)refreshingCredentialsProvider, cognitoIdentityRegion, clientConfiguration);
        cognitoCachingCredentialsProvider.setPersistenceEnabled(this.isPersistenceEnabled);
        if (clientConfiguration.getUserAgentOverride() != null) {
            cognitoCachingCredentialsProvider.setUserAgentOverride(clientConfiguration.getUserAgentOverride());
        }
        this.credentialsProviderHolder.setUnderlyingProvider(cognitoCachingCredentialsProvider);
    }

    private JSONObject getCognitoIdentityPoolConfig() throws IllegalArgumentException {
        try {
            return this.awsConfiguration.optJsonObject("CredentialsProvider").getJSONObject("CognitoIdentity").getJSONObject(this.awsConfiguration.getConfiguration());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot access Cognito IdentityPoolId from the awsconfiguration.json file.", exception);
        }
    }

    private class SignInProviderResultAdapter
    implements SignInProviderResultHandler {
        private final SignInProviderResultHandler handler;

        private SignInProviderResultAdapter(SignInProviderResultHandler handler) {
            this.handler = handler;
        }

        @Override
        public void onSuccess(IdentityProvider provider) {
            Log.d((String)LOG_TAG, (String)String.format("SignInProviderResultAdapter.onSuccess(): %s provider sign-in succeeded.", provider.getDisplayName()));
            IdentityManager.this.federateWithProvider(provider);
        }

        private void onCognitoSuccess() {
            Log.d((String)LOG_TAG, (String)"SignInProviderResultAdapter.onCognitoSuccess()");
            this.handler.onSuccess(IdentityManager.this.currentIdentityProvider);
        }

        private void onCognitoError(Exception ex) {
            Log.d((String)LOG_TAG, (String)"SignInProviderResultAdapter.onCognitoError()", (Throwable)ex);
            IdentityProvider provider = IdentityManager.this.currentIdentityProvider;
            IdentityManager.this.signOut();
            this.handler.onError(provider, new CognitoAuthException(provider, ex));
        }

        @Override
        public void onCancel(IdentityProvider provider) {
            Log.d((String)LOG_TAG, (String)String.format("SignInProviderResultAdapter.onCancel(): %s provider sign-in canceled.", provider.getDisplayName()));
            this.handler.onCancel(provider);
        }

        @Override
        public void onError(IdentityProvider provider, Exception ex) {
            Log.e((String)LOG_TAG, (String)String.format("SignInProviderResultAdapter.onError(): %s provider error. %s", provider.getDisplayName(), ex.getMessage()), (Throwable)ex);
            this.handler.onError(provider, new ProviderAuthException(provider, ex));
        }
    }

    private class AWSRefreshingCognitoIdentityProvider
    extends AWSBasicCognitoIdentityProvider {
        private final String LOG_TAG;

        public AWSRefreshingCognitoIdentityProvider(String accountId, String identityPoolId, ClientConfiguration clientConfiguration, Regions regions) {
            super(accountId, identityPoolId, clientConfiguration);
            this.LOG_TAG = AWSRefreshingCognitoIdentityProvider.class.getSimpleName();
            this.cib.setRegion(Region.getRegion((Regions)regions));
        }

        public String refresh() {
            if (IdentityManager.this.currentIdentityProvider != null) {
                Log.d((String)this.LOG_TAG, (String)"Storing the Refresh token in the loginsMap.");
                String newToken = IdentityManager.this.currentIdentityProvider.refreshToken();
                this.getLogins().put(IdentityManager.this.currentIdentityProvider.getCognitoLoginKey(), newToken);
            }
            return super.refresh();
        }
    }

    private class AWSCredentialsProviderHolder
    implements AWSCredentialsProvider {
        private volatile CognitoCachingCredentialsProvider underlyingProvider;

        private AWSCredentialsProviderHolder() {
        }

        public AWSCredentials getCredentials() {
            return this.underlyingProvider.getCredentials();
        }

        public void refresh() {
            this.underlyingProvider.refresh();
        }

        private CognitoCachingCredentialsProvider getUnderlyingProvider() {
            return this.underlyingProvider;
        }

        private void setUnderlyingProvider(CognitoCachingCredentialsProvider underlyingProvider) {
            this.underlyingProvider = underlyingProvider;
        }
    }
}

