/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.auth.core.signin.ui.buttons;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextPaint;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.amazonaws.mobile.auth.core.R;
import com.amazonaws.mobile.auth.core.signin.ui.DisplayUtils;
import com.amazonaws.mobile.auth.core.signin.ui.buttons.SignInButtonAttributes;

public class SignInButton
extends LinearLayout {
    private static final int IMAGE_LEFT_MARGIN = DisplayUtils.dp(8);
    private static final int IMAGE_RIGHT_MARGIN = DisplayUtils.dp(8);
    private static final int TEXT_LEFT_MARGIN = DisplayUtils.dp(2);
    private static final int TEXT_RIGHT_MARGIN = DisplayUtils.dp(8);
    private static final float MIN_TEXT_SIZE_SP = 8.0f;
    private static final float MAX_TEXT_SIZE_PX = DisplayUtils.dp(50);
    private static final int BORDER_COLOR = -16777216;
    private final SignInButtonAttributes attributes;
    protected ImageView imageView;
    protected TextView textView;
    protected Bitmap bitmap;
    protected boolean isSmallStyle = false;

    public SignInButton(Context context, AttributeSet attrs, int defStyleAttr, SignInButtonAttributes buttonAttributes) {
        super(context, attrs, defStyleAttr);
        String buttonText;
        this.attributes = buttonAttributes;
        this.setFocusable(true);
        this.setClickable(true);
        this.setOrientation(0);
        this.setGravity(16);
        this.setBackgroundDrawable(this.getBackgroundStatesDrawable());
        this.imageView = new ImageView(context);
        this.bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.attributes.getImageIconResourceId());
        BitmapDrawable bitmapDrawable = new BitmapDrawable(this.getResources(), this.bitmap);
        this.imageView.setImageDrawable((Drawable)bitmapDrawable);
        this.imageView.setScaleType(ImageView.ScaleType.FIT_XY);
        this.imageView.setAdjustViewBounds(true);
        LinearLayout.LayoutParams imageLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        imageLayoutParams.setMargins(IMAGE_LEFT_MARGIN, 0, IMAGE_RIGHT_MARGIN, 0);
        imageLayoutParams.weight = 0.0f;
        this.addView((View)this.imageView, (ViewGroup.LayoutParams)imageLayoutParams);
        this.textView = new TextView(context);
        this.textView.setTextColor(this.attributes.getTextColor());
        this.textView.setTypeface(null, 1);
        this.textView.setSingleLine(true);
        this.textView.setGravity(16);
        if (attrs != null) {
            TypedArray styledAttributes = context.obtainStyledAttributes(attrs, R.styleable.SignInButton);
            if (styledAttributes.getInt(R.styleable.SignInButton_button_style, 0) > 0) {
                this.isSmallStyle = true;
            }
            buttonText = styledAttributes.getString(R.styleable.SignInButton_text);
            styledAttributes.recycle();
        } else {
            buttonText = null;
        }
        if (buttonText != null) {
            this.textView.setText(buttonText);
        } else {
            this.textView.setText(this.attributes.getDefaultTextResourceId());
        }
        LinearLayout.LayoutParams textViewLayoutParams = new LinearLayout.LayoutParams(-1, -1);
        textViewLayoutParams.setMargins(DisplayUtils.dp(TEXT_LEFT_MARGIN), 0, DisplayUtils.dp(TEXT_RIGHT_MARGIN), 0);
        textViewLayoutParams.weight = 1.0f;
        this.addView((View)this.textView, (ViewGroup.LayoutParams)textViewLayoutParams);
        this.updateStyle();
        this.invalidate();
    }

    private Drawable getButtonBackground(int buttonFaceColor) {
        int cornerRadius = this.attributes.getCornerRadius();
        ShapeDrawable insetBackgroundDrawable = DisplayUtils.getRoundedRectangleBackground(cornerRadius, buttonFaceColor);
        GradientDrawable outerShadowTopDrawable = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, new int[]{this.attributes.getTopShadowColor(), this.attributes.getTopShadowColor()});
        outerShadowTopDrawable.setCornerRadius((float)DisplayUtils.dp(cornerRadius));
        GradientDrawable outerShadowBottomDrawable = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, new int[]{this.attributes.getBottomShadowColor(), this.attributes.getBottomShadowColor()});
        outerShadowBottomDrawable.setCornerRadius((float)DisplayUtils.dp(cornerRadius));
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{outerShadowTopDrawable, outerShadowBottomDrawable, insetBackgroundDrawable});
        layerDrawable.setLayerInset(0, 0, 0, 0, 0);
        layerDrawable.setLayerInset(1, this.attributes.getTopShadowThickness(), this.attributes.getTopShadowThickness(), 0, 0);
        layerDrawable.setLayerInset(2, this.attributes.getTopShadowThickness(), this.attributes.getTopShadowThickness(), this.attributes.getBottomShadowThickness(), this.attributes.getBottomShadowThickness());
        return layerDrawable;
    }

    private Drawable getBackgroundStatesDrawable() {
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{16842919}, this.getButtonBackground(this.attributes.getBackgroundColorPressed()));
        states.addState(new int[0], this.getButtonBackground(this.attributes.getBackgroundColor()));
        return states;
    }

    private void updateStyle() {
        if (this.isSmallStyle) {
            this.textView.setVisibility(8);
            this.setGravity(17);
        } else {
            this.textView.setVisibility(0);
            this.setGravity(16);
        }
    }

    public void setSmallStyle(boolean shouldSetStyleSmall) {
        this.isSmallStyle = shouldSetStyleSmall;
        this.updateStyle();
    }

    public void setButtonText(String text) {
        this.textView.setText((CharSequence)text);
        this.resizeButtonText();
    }

    public void setButtonText(int resId) {
        this.textView.setText(resId);
        this.resizeButtonText();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ViewGroup.LayoutParams layoutParams = this.imageView.getLayoutParams();
        int sideSize = (int)((double)this.getMeasuredHeight() * 0.72);
        if (sideSize > this.bitmap.getHeight()) {
            sideSize = this.bitmap.getHeight();
        }
        layoutParams.height = sideSize;
        layoutParams.width = sideSize;
    }

    private boolean doesTextViewFit(float suggestedSize, RectF availableRect) {
        TextPaint textPaint = new TextPaint((Paint)this.textView.getPaint());
        textPaint.setTextSize(suggestedSize);
        TransformationMethod transformMethod = this.textView.getTransformationMethod();
        String text = transformMethod == null ? this.textView.getText().toString() : transformMethod.getTransformation(this.textView.getText(), (View)this.textView).toString();
        RectF textRect = new RectF(0.0f, 0.0f, textPaint.measureText(text), textPaint.getFontSpacing());
        return availableRect.contains(textRect);
    }

    private float findBestSize(float start, float end, RectF availableSpace) {
        float low = start;
        float high = end;
        float bestFit = low;
        while (low <= high) {
            float midpoint = (low + high) / 2.0f;
            if (this.doesTextViewFit(midpoint, availableSpace)) {
                bestFit = midpoint;
                low = midpoint + 0.5f;
                continue;
            }
            high = midpoint - 0.5f;
        }
        return bestFit;
    }

    private void resizeButtonText() {
        if (this.getMeasuredWidth() == 0 || this.isSmallStyle) {
            return;
        }
        float minTextSize = TypedValue.applyDimension((int)2, (float)8.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RectF availableSpaceRect = new RectF();
        availableSpaceRect.right = this.textView.getMeasuredWidth() - this.textView.getCompoundPaddingLeft() - this.textView.getCompoundPaddingRight();
        availableSpaceRect.bottom = this.textView.getMeasuredHeight() - this.textView.getCompoundPaddingBottom() - this.textView.getCompoundPaddingTop();
        this.textView.setTextSize(0, this.findBestSize(minTextSize, MAX_TEXT_SIZE_PX, availableSpaceRect));
    }

    protected void onSizeChanged(int width, int height, int oldwidth, int oldheight) {
        super.onSizeChanged(width, height, oldwidth, oldheight);
        if (width != oldwidth || height != oldheight) {
            this.resizeButtonText();
        }
    }
}

