/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.apigateway;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.Signer;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.http.HttpRequestFactory;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.UrlHttpClient;
import com.amazonaws.mobileconnectors.apigateway.ApiClientException;
import com.amazonaws.mobileconnectors.apigateway.ApiRequest;
import com.amazonaws.mobileconnectors.apigateway.ApiResponse;
import com.amazonaws.mobileconnectors.apigateway.annotation.Operation;
import com.amazonaws.mobileconnectors.apigateway.annotation.Parameter;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.Map;

class ApiClientHandler
implements InvocationHandler {
    private static final Gson gson = new Gson();
    private final String endpoint;
    private final String apiName;
    private final Signer signer;
    private final AWSCredentialsProvider provider;
    private final String apiKey;
    private final HttpClient client;
    private final HttpRequestFactory requestFactory;
    private final ClientConfiguration clientConfiguration;

    ApiClientHandler(String endpoint, String apiName, Signer signer, AWSCredentialsProvider provider, String apiKey, ClientConfiguration clientConfiguration) {
        this.endpoint = endpoint;
        this.apiName = apiName;
        this.signer = signer;
        this.provider = provider;
        this.apiKey = apiKey;
        this.clientConfiguration = clientConfiguration;
        this.client = new UrlHttpClient(this.clientConfiguration);
        this.requestFactory = new HttpRequestFactory();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (this.isExecuteMethod(method)) {
                HttpRequest httpRequest = this.invokeExecuteMethod(args);
                HttpResponse response = this.client.execute(httpRequest);
                return new ApiResponse(response);
            }
            HttpRequest httpRequest = this.createHttpRequest(method, args);
            HttpResponse response = this.client.execute(httpRequest);
            return this.handleResponse(response, method);
        }
        catch (ApiClientException ace) {
            throw ace;
        }
        catch (Exception e) {
            String msg = e.getMessage() == null ? "" : e.getMessage();
            throw new ApiClientException(msg, e);
        }
    }

    HttpRequest createHttpRequest(Method method, Object[] args) {
        Request<?> request = this.buildRequest(method, args);
        ExecutionContext context = new ExecutionContext();
        String userAgent = this.apiName;
        if (request.getHeaders().containsKey("User-Agent")) {
            userAgent = userAgent + " " + (String)request.getHeaders().get("User-Agent");
        }
        context.setContextUserAgent(userAgent);
        return this.requestFactory.createHttpRequest(request, this.clientConfiguration, context);
    }

    Request<?> buildRequest(Method method, Object[] args) {
        Operation op = method.getAnnotation(Operation.class);
        if (op == null) {
            throw new IllegalArgumentException("Method isn't annotated with Operation");
        }
        DefaultRequest request = new DefaultRequest(this.apiName);
        request.setResourcePath(op.path());
        request.setEndpoint(URI.create(this.endpoint));
        String content = null;
        Annotation[][] annotations = method.getParameterAnnotations();
        int length = annotations.length;
        block0: for (int i = 0; i < length; ++i) {
            if (annotations[i].length == 0) {
                if (content != null) {
                    throw new IllegalStateException("Can't have more than one Body");
                }
                content = args[i] == null ? null : gson.toJson(args[i]);
                continue;
            }
            for (Annotation annotation : annotations[i]) {
                if (!(annotation instanceof Parameter)) continue;
                this.processParameter((Request<?>)request, (Parameter)annotation, args[i]);
                continue block0;
            }
        }
        boolean hasContent = content != null;
        this.setHttpMethod((Request<?>)request, op.method(), hasContent);
        if (hasContent) {
            byte[] contentBytes = content.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new ByteArrayInputStream(contentBytes));
            request.addHeader("Content-Length", String.valueOf(contentBytes.length));
        }
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Accept", "application/json");
        if (this.apiKey != null) {
            request.addHeader("x-api-key", this.apiKey);
        }
        if (this.provider != null && this.signer != null) {
            this.signer.sign((Request)request, this.provider.getCredentials());
        }
        return request;
    }

    void processParameter(Request<?> request, Parameter p, Object arg) {
        String name = p.name();
        String location = p.location();
        if ("header".equals(location)) {
            request.addHeader(name, String.valueOf(arg));
        } else if ("path".equals(location)) {
            String path = request.getResourcePath();
            path = path.replaceAll("\\{" + name + "\\}", String.valueOf(arg));
            request.setResourcePath(path);
        } else if ("query".equals(location)) {
            if (Map.class.isAssignableFrom(arg.getClass())) {
                Map map = (Map)arg;
                for (Map.Entry entry : map.entrySet()) {
                    request.addParameter((String)entry.getKey(), String.valueOf(entry.getValue()));
                }
            } else if (Collection.class.isAssignableFrom(arg.getClass())) {
                request.addParameter(name, this.joinList((Collection)arg));
            } else {
                request.addParameter(name, String.valueOf(arg));
            }
        } else {
            throw new IllegalArgumentException("unknown parameter location: " + location);
        }
    }

    void setHttpMethod(Request<?> request, String httpMethod, boolean hasContent) {
        try {
            request.setHttpMethod(HttpMethodName.valueOf((String)httpMethod));
        }
        catch (IllegalArgumentException iae) {
            request.addHeader("X-HTTP-Method-Override", httpMethod);
            request.setHttpMethod(hasContent ? HttpMethodName.POST : HttpMethodName.GET);
        }
    }

    Object handleResponse(HttpResponse response, Method method) throws Throwable {
        int code = response.getStatusCode();
        InputStream content = response.getContent();
        if (code >= 200 && code < 300) {
            Class<?> t = method.getReturnType();
            if (t != Void.TYPE && content != null) {
                InputStreamReader reader = new InputStreamReader(response.getContent(), StringUtils.UTF8);
                Object obj = gson.fromJson((Reader)reader, t);
                ((Reader)reader).close();
                return obj;
            }
            if (content != null) {
                content.close();
            }
            return null;
        }
        String error = content == null ? "" : IOUtils.toString((InputStream)content);
        ApiClientException ase = new ApiClientException(error);
        ase.setStatusCode(response.getStatusCode());
        ase.setServiceName(this.apiName);
        String requestId = (String)response.getHeaders().get("x-amzn-RequestId");
        if (requestId != null) {
            ase.setRequestId(requestId);
        }
        throw ase;
    }

    boolean isExecuteMethod(Method method) {
        Operation op = method.getAnnotation(Operation.class);
        return op == null && method.getName().equalsIgnoreCase("execute") && method.getReturnType().isAssignableFrom(ApiResponse.class) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].isAssignableFrom(ApiRequest.class);
    }

    HttpRequest invokeExecuteMethod(Object[] args) {
        ExecutionContext context = new ExecutionContext();
        Request<ApiResponse> request = ((ApiRequest)args[0]).getRequest();
        if (request.getEndpoint() == null) {
            request.setEndpoint(URI.create(this.endpoint));
        }
        String userAgent = this.apiName;
        if (request.getHeaders().containsKey("User-Agent")) {
            userAgent = userAgent + " " + (String)request.getHeaders().get("User-Agent");
        }
        context.setContextUserAgent(userAgent);
        if (this.apiKey != null) {
            request.addHeader("x-api-key", this.apiKey);
        }
        if (this.provider != null && this.signer != null) {
            this.signer.sign(request, this.provider.getCredentials());
        }
        return this.requestFactory.createHttpRequest(request, this.clientConfiguration, context);
    }

    private String joinList(Collection<?> objects) {
        if (objects == null || objects.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object object : objects) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(object);
        }
        return sb.toString();
    }
}

