/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.acknowledge;

import com.amazon.sqs.javamessaging.message.SQSMessage;
import jakarta.jms.JMSException;

public class SQSMessageIdentifier {
    private final String queueUrl;
    private final String receiptHandle;
    private final String sqsMessageId;
    private String groupId;

    public SQSMessageIdentifier(String queueUrl, String receiptHandle, String sqsMessageId) {
        this(queueUrl, receiptHandle, sqsMessageId, null);
    }

    public SQSMessageIdentifier(String queueUrl, String receiptHandle, String sqsMessageId, String groupId) {
        this.queueUrl = queueUrl;
        this.receiptHandle = receiptHandle;
        this.sqsMessageId = sqsMessageId;
        this.groupId = groupId;
        if (this.groupId != null && this.groupId.isEmpty()) {
            this.groupId = null;
        }
    }

    public static SQSMessageIdentifier fromSQSMessage(SQSMessage sqsMessage) throws JMSException {
        return new SQSMessageIdentifier(sqsMessage.getQueueUrl(), sqsMessage.getReceiptHandle(), sqsMessage.getSQSMessageId(), sqsMessage.getSQSMessageGroupId());
    }

    public String toString() {
        return "SQSMessageIdentifier(queueUrl=" + this.getQueueUrl() + ", receiptHandle=" + this.getReceiptHandle() + ", sqsMessageId=" + this.getSqsMessageId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQSMessageIdentifier)) {
            return false;
        }
        SQSMessageIdentifier other = (SQSMessageIdentifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$queueUrl = this.getQueueUrl();
        String other$queueUrl = other.getQueueUrl();
        if (this$queueUrl == null ? other$queueUrl != null : !this$queueUrl.equals(other$queueUrl)) {
            return false;
        }
        String this$receiptHandle = this.getReceiptHandle();
        String other$receiptHandle = other.getReceiptHandle();
        if (this$receiptHandle == null ? other$receiptHandle != null : !this$receiptHandle.equals(other$receiptHandle)) {
            return false;
        }
        String this$sqsMessageId = this.getSqsMessageId();
        String other$sqsMessageId = other.getSqsMessageId();
        return !(this$sqsMessageId == null ? other$sqsMessageId != null : !this$sqsMessageId.equals(other$sqsMessageId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SQSMessageIdentifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $queueUrl = this.getQueueUrl();
        result = result * 59 + ($queueUrl == null ? 43 : $queueUrl.hashCode());
        String $receiptHandle = this.getReceiptHandle();
        result = result * 59 + ($receiptHandle == null ? 43 : $receiptHandle.hashCode());
        String $sqsMessageId = this.getSqsMessageId();
        result = result * 59 + ($sqsMessageId == null ? 43 : $sqsMessageId.hashCode());
        return result;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public String getReceiptHandle() {
        return this.receiptHandle;
    }

    public String getSqsMessageId() {
        return this.sqsMessageId;
    }

    public String getGroupId() {
        return this.groupId;
    }
}

