/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.message;

import com.amazon.sqs.javamessaging.acknowledge.Acknowledger;
import com.amazon.sqs.javamessaging.message.SQSMessage;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQSBytesMessage
extends SQSMessage
implements BytesMessage {
    private static final Log LOG = LogFactory.getLog(SQSBytesMessage.class);
    private byte[] bytes;
    private ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
    private DataInputStream dataIn;
    private DataOutputStream dataOut = new DataOutputStream(this.bytesOut);

    public SQSBytesMessage(Acknowledger acknowledger, String queueUrl, Message sqsMessage) throws JMSException {
        super(acknowledger, queueUrl, sqsMessage);
        try {
            this.dataOut.write(Base64.decode((String)sqsMessage.getBody()));
            this.reset();
        }
        catch (IOException e) {
            LOG.error((Object)"IOException: Message cannot be written", (Throwable)e);
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected exception: ", (Throwable)e);
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public SQSBytesMessage() throws JMSException {
    }

    public long getBodyLength() throws JMSException {
        this.checkCanRead();
        return this.bytes.length;
    }

    public boolean readBoolean() throws JMSException {
        this.checkCanRead();
        try {
            return this.dataIn.readBoolean();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public byte readByte() throws JMSException {
        this.checkCanRead();
        try {
            return this.dataIn.readByte();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.checkCanRead();
        try {
            return this.dataIn.readUnsignedByte();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public short readShort() throws JMSException {
        this.checkCanRead();
        try {
            return this.dataIn.readShort();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.checkCanRead();
        try {
            return this.dataIn.readUnsignedShort();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public char readChar() throws JMSException {
        this.checkCanRead();
        try {
            return this.dataIn.readChar();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public int readInt() throws JMSException {
        this.checkCanRead();
        try {
            return this.dataIn.readInt();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public long readLong() throws JMSException {
        this.checkCanRead();
        try {
            return this.dataIn.readLong();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public float readFloat() throws JMSException {
        this.checkCanRead();
        try {
            return this.dataIn.readFloat();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public double readDouble() throws JMSException {
        this.checkCanRead();
        try {
            return this.dataIn.readDouble();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public String readUTF() throws JMSException {
        this.checkCanRead();
        try {
            return this.dataIn.readUTF();
        }
        catch (EOFException e) {
            throw new MessageEOFException(e.getMessage());
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length bytes to read can't be smaller than 0 but was " + length);
        }
        this.checkCanRead();
        try {
            int n;
            int count;
            for (n = 0; n < length && (count = this.dataIn.read(value, n, length - n)) >= 0; n += count) {
            }
            if (n == 0 && length > 0) {
                n = -1;
            }
            return n;
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkCanWrite();
        try {
            this.dataOut.writeBoolean(value);
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.checkCanWrite();
        try {
            this.dataOut.writeByte(value);
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public void writeShort(short value) throws JMSException {
        this.checkCanWrite();
        try {
            this.dataOut.writeShort(value);
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.checkCanWrite();
        try {
            this.dataOut.writeChar(value);
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.checkCanWrite();
        try {
            this.dataOut.writeInt(value);
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.checkCanWrite();
        try {
            this.dataOut.writeLong(value);
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.checkCanWrite();
        try {
            this.dataOut.writeFloat(value);
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.checkCanWrite();
        try {
            this.dataOut.writeDouble(value);
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.checkCanWrite();
        try {
            this.dataOut.writeUTF(value);
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkCanWrite();
        try {
            this.dataOut.write(value);
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkCanWrite();
        try {
            this.dataOut.write(value, offset, length);
        }
        catch (IOException e) {
            throw SQSBytesMessage.convertExceptionToJMSException(e);
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException("Cannot write null value of object");
        }
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF(value.toString());
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Cannot write non-primitive type: " + value.getClass());
        }
    }

    public void reset() throws JMSException {
        if (this.dataOut != null) {
            this.bytes = this.bytesOut.toByteArray();
            this.dataOut = null;
            this.bytesOut = null;
        }
        this.dataIn = new DataInputStream(new ByteArrayInputStream(this.bytes));
    }

    @Override
    public void clearBody() throws JMSException {
        this.bytes = null;
        this.dataIn = null;
        this.bytesOut = new ByteArrayOutputStream();
        this.dataOut = new DataOutputStream(this.bytesOut);
        this.setBodyWritePermissions(true);
    }

    public byte[] getBodyAsBytes() throws JMSException {
        if (this.bytes != null) {
            return Arrays.copyOf(this.bytes, this.bytes.length);
        }
        return this.bytesOut.toByteArray();
    }

    void checkCanRead() throws JMSException {
        if (this.bytes == null) {
            throw new MessageNotReadableException("Message is not readable");
        }
    }

    void checkCanWrite() throws JMSException {
        if (this.dataOut == null) {
            throw new MessageNotWriteableException("Message is not writeable");
        }
    }

    void setDataIn(DataInputStream dataIn) {
        this.dataIn = dataIn;
    }

    void setDataOut(DataOutputStream dataOut) {
        this.dataOut = dataOut;
    }
}

