/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper;
import com.amazon.sqs.javamessaging.PrefetchManager;
import com.amazon.sqs.javamessaging.SQSMessageConsumer;
import com.amazon.sqs.javamessaging.SQSQueueDestination;
import com.amazon.sqs.javamessaging.SQSSessionCallbackScheduler;
import com.amazon.sqs.javamessaging.acknowledge.Acknowledger;
import com.amazon.sqs.javamessaging.acknowledge.NegativeAcknowledger;
import com.amazon.sqs.javamessaging.acknowledge.SQSMessageIdentifier;
import com.amazon.sqs.javamessaging.message.SQSBytesMessage;
import com.amazon.sqs.javamessaging.message.SQSMessage;
import com.amazon.sqs.javamessaging.message.SQSObjectMessage;
import com.amazon.sqs.javamessaging.message.SQSTextMessage;
import com.amazon.sqs.javamessaging.util.ExponentialBackoffStrategy;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQSMessageConsumerPrefetch
implements Runnable,
PrefetchManager {
    private static final Log LOG = LogFactory.getLog(SQSMessageConsumerPrefetch.class);
    protected static final int WAIT_TIME_SECONDS = 20;
    protected static final String ALL = "All";
    private final AmazonSQSMessagingClientWrapper amazonSQSClient;
    private final String queueUrl;
    private final int numberOfMessagesToPrefetch;
    private final SQSQueueDestination sqsDestination;
    protected final ArrayDeque<MessageManager> messageQueue;
    private final Acknowledger acknowledger;
    private final NegativeAcknowledger negativeAcknowledger;
    private volatile MessageListener messageListener;
    private SQSMessageConsumer messageConsumer;
    private final SQSSessionCallbackScheduler sqsSessionRunnable;
    protected int messagesPrefetched = 0;
    protected volatile boolean closed = false;
    protected volatile boolean running = false;
    protected int retriesAttempted = 0;
    private final Object stateLock = new Object();
    protected ExponentialBackoffStrategy backoffStrategy = new ExponentialBackoffStrategy(25L, 25L, 2000L);

    SQSMessageConsumerPrefetch(SQSSessionCallbackScheduler sqsSessionRunnable, Acknowledger acknowledger, NegativeAcknowledger negativeAcknowledger, SQSQueueDestination sqsDestination, AmazonSQSMessagingClientWrapper amazonSQSClient, int numberOfMessagesToPrefetch) {
        this.amazonSQSClient = amazonSQSClient;
        this.numberOfMessagesToPrefetch = numberOfMessagesToPrefetch;
        this.acknowledger = acknowledger;
        this.negativeAcknowledger = negativeAcknowledger;
        this.queueUrl = sqsDestination.getQueueUrl();
        this.sqsDestination = sqsDestination;
        this.sqsSessionRunnable = sqsSessionRunnable;
        this.messageQueue = new ArrayDeque(numberOfMessagesToPrefetch);
    }

    MessageListener getMessageListener() {
        return this.messageListener;
    }

    void setMessageConsumer(SQSMessageConsumer messageConsumer) {
        this.messageConsumer = messageConsumer;
    }

    @Override
    public SQSMessageConsumer getMessageConsumer() {
        return this.messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
        if (messageListener == null || this.isClosed()) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.running || this.isClosed()) {
                return;
            }
            ArrayList<MessageManager> allPrefetchedMessages = new ArrayList<MessageManager>(this.messageQueue);
            this.sqsSessionRunnable.scheduleCallBacks(messageListener, allPrefetchedMessages);
            this.messageQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            boolean nackQueueMessages = false;
            List<Message> messages = null;
            try {
                int prefetchBatchSize;
                if (this.isClosed()) break;
                Object object = this.stateLock;
                synchronized (object) {
                    this.waitForStart();
                    this.waitForPrefetch();
                    prefetchBatchSize = Math.min(this.numberOfMessagesToPrefetch - this.messagesPrefetched, 10);
                }
                if (!this.isClosed()) {
                    messages = this.getMessages(prefetchBatchSize);
                }
                if (messages == null || messages.isEmpty()) continue;
                this.processReceivedMessages(messages);
                continue;
            }
            catch (InterruptedException e) {
                nackQueueMessages = true;
            }
            catch (Throwable e) {
                LOG.error((Object)"Unexpected exception when prefetch messages:", e);
                nackQueueMessages = true;
                throw new RuntimeException(e);
            }
            finally {
                if (!this.isClosed() && !nackQueueMessages) continue;
                this.nackQueueMessages();
                continue;
            }
            break;
        }
    }

    protected List<Message> getMessages(int prefetchBatchSize) throws InterruptedException {
        assert (prefetchBatchSize > 0);
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(this.queueUrl).withMaxNumberOfMessages(Integer.valueOf(prefetchBatchSize)).withAttributeNames(new String[]{ALL}).withMessageAttributeNames(new String[]{ALL}).withWaitTimeSeconds(Integer.valueOf(20));
        if (this.sqsDestination.isFifo()) {
            receiveMessageRequest.withReceiveRequestAttemptId(UUID.randomUUID().toString());
        }
        List messages = null;
        try {
            ReceiveMessageResult receivedMessageResult = this.amazonSQSClient.receiveMessage(receiveMessageRequest);
            messages = receivedMessageResult.getMessages();
            this.retriesAttempted = 0;
        }
        catch (JMSException e) {
            LOG.warn((Object)"Encountered exception during receive in ConsumerPrefetch thread", (Throwable)e);
            try {
                this.sleep(this.backoffStrategy.delayBeforeNextRetry(this.retriesAttempted++));
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)"Interrupted while retrying on receive", (Throwable)ex);
                throw ex;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processReceivedMessages(List<Message> messages) {
        ArrayList<String> nackMessages = new ArrayList<String>();
        ArrayList<MessageManager> messageManagers = new ArrayList<MessageManager>();
        for (Message message : messages) {
            try {
                javax.jms.Message jmsMessage = this.convertToJMSMessage(message);
                messageManagers.add(new MessageManager(this, jmsMessage));
            }
            catch (JMSException e) {
                nackMessages.add(message.getReceiptHandle());
            }
        }
        Object i$ = this.stateLock;
        synchronized (i$) {
            if (this.messageListener != null) {
                this.sqsSessionRunnable.scheduleCallBacks(this.messageListener, messageManagers);
            } else {
                this.messageQueue.addAll(messageManagers);
            }
            this.messagesPrefetched += messageManagers.size();
            this.notifyStateChange();
        }
        try {
            this.negativeAcknowledger.action(this.queueUrl, nackMessages);
        }
        catch (JMSException e) {
            LOG.warn((Object)"Caught exception while nacking received messages", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForPrefetch() throws InterruptedException {
        Object object = this.stateLock;
        synchronized (object) {
            while (this.messagesPrefetched >= this.numberOfMessagesToPrefetch && !this.isClosed()) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted while waiting on prefetch", (Throwable)e);
                    throw e;
                }
            }
        }
    }

    protected javax.jms.Message convertToJMSMessage(Message message) throws JMSException {
        MessageAttributeValue messageTypeAttribute = (MessageAttributeValue)message.getMessageAttributes().get("JMS_SQSMessageType");
        SQSMessage jmsMessage = null;
        if (messageTypeAttribute == null) {
            jmsMessage = new SQSTextMessage(this.acknowledger, this.queueUrl, message);
        } else {
            String messageType = messageTypeAttribute.getStringValue();
            if ("byte".equals(messageType)) {
                try {
                    jmsMessage = new SQSBytesMessage(this.acknowledger, this.queueUrl, message);
                }
                catch (JMSException e) {
                    LOG.warn((Object)("MessageReceiptHandle - " + message.getReceiptHandle() + "cannot be serialized to BytesMessage"), (Throwable)e);
                    throw e;
                }
            } else if ("object".equals(messageType)) {
                jmsMessage = new SQSObjectMessage(this.acknowledger, this.queueUrl, message);
            } else if ("text".equals(messageType)) {
                jmsMessage = new SQSTextMessage(this.acknowledger, this.queueUrl, message);
            } else {
                throw new JMSException("Not a supported JMS message type");
            }
        }
        jmsMessage.setJMSDestination(this.sqsDestination);
        return jmsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nackQueueMessages() {
        Object object = this.stateLock;
        synchronized (object) {
            try {
                this.negativeAcknowledger.bulkAction(this.messageQueue, this.queueUrl);
            }
            catch (JMSException e) {
                LOG.warn((Object)"Caught exception while nacking queued messages", (Throwable)e);
            }
            finally {
                this.notifyStateChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForStart() throws InterruptedException {
        Object object = this.stateLock;
        synchronized (object) {
            while (!this.running && !this.isClosed()) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted while waiting on consumer start", (Throwable)e);
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageDispatched() {
        Object object = this.stateLock;
        synchronized (object) {
            --this.messagesPrefetched;
            if (this.messagesPrefetched < this.numberOfMessagesToPrefetch) {
                this.notifyStateChange();
            }
        }
    }

    javax.jms.Message receive() throws JMSException {
        return this.receive(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    javax.jms.Message receive(long timeout) throws JMSException {
        MessageManager messageManager;
        if (this.cannotDeliver()) {
            return null;
        }
        if (timeout < 0L) {
            timeout = 0L;
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.messageQueue.isEmpty()) {
                messageManager = this.messageQueue.pollFirst();
            } else {
                long startTime = System.currentTimeMillis();
                long waitTime = 0L;
                while (this.messageQueue.isEmpty() && !this.isClosed() && (timeout == 0L || (waitTime = this.getWaitTime(timeout, startTime)) > 0L)) {
                    try {
                        this.stateLock.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                if (this.messageQueue.isEmpty() || this.isClosed()) {
                    return null;
                }
                messageManager = this.messageQueue.pollFirst();
            }
        }
        return this.messageHandler(messageManager);
    }

    private long getWaitTime(long timeout, long startTime) {
        return timeout - (System.currentTimeMillis() - startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStateChange() {
        Object object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    javax.jms.Message receiveNoWait() throws JMSException {
        MessageManager messageManager;
        if (this.cannotDeliver()) {
            return null;
        }
        Object object = this.stateLock;
        synchronized (object) {
            messageManager = this.messageQueue.pollFirst();
        }
        return this.messageHandler(messageManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        if (this.isClosed() || this.running) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.running = true;
            this.notifyStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (this.isClosed() || !this.running) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.running = false;
            this.notifyStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.isClosed()) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.closed = true;
            this.notifyStateChange();
            this.messageListener = null;
        }
    }

    private javax.jms.Message messageHandler(MessageManager messageManager) throws JMSException {
        if (messageManager == null) {
            return null;
        }
        javax.jms.Message message = messageManager.getMessage();
        this.messageDispatched();
        this.acknowledger.notifyMessageReceived((SQSMessage)message);
        return message;
    }

    private boolean cannotDeliver() throws JMSException {
        if (this.isClosed() || !this.running) {
            return true;
        }
        if (this.messageListener != null) {
            throw new JMSException("Cannot receive messages synchronously after a message listener is set");
        }
        return false;
    }

    protected void sleep(long sleepTimeMillis) throws InterruptedException {
        Thread.sleep(sleepTimeMillis);
    }

    protected boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SQSMessageIdentifier> purgePrefetchedMessagesWithGroups(Set<String> affectedGroups) throws JMSException {
        ArrayList<SQSMessageIdentifier> purgedMessages = new ArrayList<SQSMessageIdentifier>();
        Object object = this.stateLock;
        synchronized (object) {
            Iterator<MessageManager> managerIterator = this.messageQueue.iterator();
            while (managerIterator.hasNext()) {
                MessageManager messageManager = managerIterator.next();
                SQSMessage prefetchedMessage = (SQSMessage)messageManager.getMessage();
                SQSMessageIdentifier messageIdentifier = SQSMessageIdentifier.fromSQSMessage(prefetchedMessage);
                if (!affectedGroups.contains(messageIdentifier.getGroupId())) continue;
                purgedMessages.add(messageIdentifier);
                managerIterator.remove();
                --this.messagesPrefetched;
            }
            this.notifyStateChange();
        }
        return purgedMessages;
    }

    public static class MessageManager {
        private final PrefetchManager prefetchManager;
        private final javax.jms.Message message;

        public MessageManager(PrefetchManager prefetchManager, javax.jms.Message message) {
            this.prefetchManager = prefetchManager;
            this.message = message;
        }

        public PrefetchManager getPrefetchManager() {
            return this.prefetchManager;
        }

        public javax.jms.Message getMessage() {
            return this.message;
        }
    }
}

