/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.acknowledge;

import com.amazon.sqs.javamessaging.AmazonSQSMessagingClientWrapper;
import com.amazon.sqs.javamessaging.SQSMessageConsumerPrefetch;
import com.amazon.sqs.javamessaging.acknowledge.BulkSQSOperation;
import com.amazon.sqs.javamessaging.message.SQSMessage;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.JMSException;

public class NegativeAcknowledger
extends BulkSQSOperation {
    private static final AtomicLong DEFAULT_BATCH_ID_GENERATOR = new AtomicLong();
    private static final int NACK_TIMEOUT = 0;
    private final AtomicLong batchIdGenerator;
    private final AmazonSQSMessagingClientWrapper amazonSQSClient;

    public NegativeAcknowledger(AmazonSQSMessagingClientWrapper amazonSQSClient, AtomicLong batchIdGenerator) {
        this.amazonSQSClient = amazonSQSClient;
        this.batchIdGenerator = batchIdGenerator;
    }

    public NegativeAcknowledger(AmazonSQSMessagingClientWrapper amazonSQSClient) {
        this.amazonSQSClient = amazonSQSClient;
        this.batchIdGenerator = DEFAULT_BATCH_ID_GENERATOR;
    }

    public void bulkAction(ArrayDeque<SQSMessageConsumerPrefetch.MessageManager> messageQueue, String queueUrl) throws JMSException {
        ArrayList<String> receiptHandles = new ArrayList<String>();
        while (!messageQueue.isEmpty()) {
            receiptHandles.add(((SQSMessage)messageQueue.pollFirst().getMessage()).getReceiptHandle());
            if (receiptHandles.size() != 10) continue;
            this.action(queueUrl, receiptHandles);
            receiptHandles.clear();
        }
        this.action(queueUrl, receiptHandles);
    }

    @Override
    public void action(String queueUrl, List<String> receiptHandles) throws JMSException {
        if (receiptHandles == null || receiptHandles.isEmpty()) {
            return;
        }
        ArrayList<ChangeMessageVisibilityBatchRequestEntry> nackEntries = new ArrayList<ChangeMessageVisibilityBatchRequestEntry>(receiptHandles.size());
        for (String messageReceiptHandle : receiptHandles) {
            ChangeMessageVisibilityBatchRequestEntry changeMessageVisibilityBatchRequestEntry = new ChangeMessageVisibilityBatchRequestEntry(this.batchIdGenerator.getAndIncrement() + "", messageReceiptHandle).withVisibilityTimeout(Integer.valueOf(0));
            nackEntries.add(changeMessageVisibilityBatchRequestEntry);
        }
        this.amazonSQSClient.changeMessageVisibilityBatch(new ChangeMessageVisibilityBatchRequest(queueUrl, nackEntries));
    }
}

