/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.AmazonSQSExtendedClientBase;
import com.amazon.sqs.javamessaging.ExtendedClientConfiguration;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.PurgeQueueResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.payloadoffloading.PayloadS3Pointer;
import software.amazon.payloadoffloading.PayloadStore;
import software.amazon.payloadoffloading.S3BackedPayloadStore;
import software.amazon.payloadoffloading.S3Dao;
import software.amazon.payloadoffloading.Util;

public class AmazonSQSExtendedClient
extends AmazonSQSExtendedClientBase
implements AmazonSQS {
    private static final Log LOG = LogFactory.getLog(AmazonSQSExtendedClient.class);
    private static final String USER_AGENT_HEADER = Util.getUserAgentHeader((String)AmazonSQSExtendedClient.class.getSimpleName());
    static final String LEGACY_RESERVED_ATTRIBUTE_NAME = "SQSLargePayloadSize";
    static final List<String> RESERVED_ATTRIBUTE_NAMES = Arrays.asList("SQSLargePayloadSize", "ExtendedPayloadSize");
    private ExtendedClientConfiguration clientConfiguration;
    private PayloadStore payloadStore;

    public AmazonSQSExtendedClient(AmazonSQS sqsClient) {
        this(sqsClient, new ExtendedClientConfiguration());
    }

    public AmazonSQSExtendedClient(AmazonSQS sqsClient, ExtendedClientConfiguration extendedClientConfig) {
        super(sqsClient);
        this.clientConfiguration = new ExtendedClientConfiguration(extendedClientConfig);
        S3Dao s3Dao = new S3Dao(this.clientConfiguration.getAmazonS3Client());
        this.payloadStore = new S3BackedPayloadStore(s3Dao, this.clientConfiguration.getS3BucketName(), this.clientConfiguration.getSSEAwsKeyManagementParams());
    }

    @Override
    public SendMessageResult sendMessage(SendMessageRequest sendMessageRequest) {
        if (sendMessageRequest == null) {
            String errorMessage = "sendMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        sendMessageRequest.getRequestClientOptions().appendUserAgent(USER_AGENT_HEADER);
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.sendMessage(sendMessageRequest);
        }
        if (sendMessageRequest.getMessageBody() == null || "".equals(sendMessageRequest.getMessageBody())) {
            String errorMessage = "messageBody cannot be null or empty.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        this.checkMessageAttributes(sendMessageRequest.getMessageAttributes());
        if (this.clientConfiguration.isAlwaysThroughS3() || this.isLarge(sendMessageRequest)) {
            sendMessageRequest = this.storeMessageInS3(sendMessageRequest);
        }
        return super.sendMessage(sendMessageRequest);
    }

    @Override
    public SendMessageResult sendMessage(String queueUrl, String messageBody) {
        SendMessageRequest sendMessageRequest = new SendMessageRequest(queueUrl, messageBody);
        return this.sendMessage(sendMessageRequest);
    }

    @Override
    public ReceiveMessageResult receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        if (receiveMessageRequest == null) {
            String errorMessage = "receiveMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        receiveMessageRequest.getRequestClientOptions().appendUserAgent(USER_AGENT_HEADER);
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.receiveMessage(receiveMessageRequest);
        }
        receiveMessageRequest.getMessageAttributeNames().removeAll(RESERVED_ATTRIBUTE_NAMES);
        receiveMessageRequest.getMessageAttributeNames().addAll(RESERVED_ATTRIBUTE_NAMES);
        ReceiveMessageResult receiveMessageResult = super.receiveMessage(receiveMessageRequest);
        List messages = receiveMessageResult.getMessages();
        for (Message message : messages) {
            Optional<String> largePayloadAttributeName = this.getReservedAttributeNameIfPresent(message.getMessageAttributes());
            if (!largePayloadAttributeName.isPresent()) continue;
            String largeMessagePointer = message.getBody();
            message.setBody(this.payloadStore.getOriginalPayload(largeMessagePointer));
            message.getMessageAttributes().keySet().removeAll(RESERVED_ATTRIBUTE_NAMES);
            String modifiedReceiptHandle = this.embedS3PointerInReceiptHandle(message.getReceiptHandle(), largeMessagePointer);
            message.setReceiptHandle(modifiedReceiptHandle);
        }
        return receiveMessageResult;
    }

    @Override
    public ReceiveMessageResult receiveMessage(String queueUrl) {
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(queueUrl);
        return this.receiveMessage(receiveMessageRequest);
    }

    @Override
    public DeleteMessageResult deleteMessage(DeleteMessageRequest deleteMessageRequest) {
        String receiptHandle;
        if (deleteMessageRequest == null) {
            String errorMessage = "deleteMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        deleteMessageRequest.getRequestClientOptions().appendUserAgent(USER_AGENT_HEADER);
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.deleteMessage(deleteMessageRequest);
        }
        String origReceiptHandle = receiptHandle = deleteMessageRequest.getReceiptHandle();
        if (this.isS3ReceiptHandle(receiptHandle)) {
            origReceiptHandle = this.getOrigReceiptHandle(receiptHandle);
            if (this.clientConfiguration.doesCleanupS3Payload()) {
                String messagePointer = this.getMessagePointerFromModifiedReceiptHandle(receiptHandle);
                this.payloadStore.deleteOriginalPayload(messagePointer);
            }
        }
        deleteMessageRequest.setReceiptHandle(origReceiptHandle);
        return super.deleteMessage(deleteMessageRequest);
    }

    @Override
    public DeleteMessageResult deleteMessage(String queueUrl, String receiptHandle) {
        DeleteMessageRequest deleteMessageRequest = new DeleteMessageRequest(queueUrl, receiptHandle);
        return this.deleteMessage(deleteMessageRequest);
    }

    @Override
    public ChangeMessageVisibilityResult changeMessageVisibility(String queueUrl, String receiptHandle, Integer visibilityTimeout) {
        ChangeMessageVisibilityRequest changeMessageVisibilityRequest = new ChangeMessageVisibilityRequest(queueUrl, receiptHandle, visibilityTimeout);
        return this.changeMessageVisibility(changeMessageVisibilityRequest);
    }

    @Override
    public ChangeMessageVisibilityResult changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws AmazonServiceException, AmazonClientException {
        if (this.isS3ReceiptHandle(changeMessageVisibilityRequest.getReceiptHandle())) {
            changeMessageVisibilityRequest.setReceiptHandle(this.getOrigReceiptHandle(changeMessageVisibilityRequest.getReceiptHandle()));
        }
        return this.amazonSqsToBeExtended.changeMessageVisibility(changeMessageVisibilityRequest);
    }

    @Override
    public SendMessageBatchResult sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) {
        if (sendMessageBatchRequest == null) {
            String errorMessage = "sendMessageBatchRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        sendMessageBatchRequest.getRequestClientOptions().appendUserAgent(USER_AGENT_HEADER);
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.sendMessageBatch(sendMessageBatchRequest);
        }
        List batchEntries = sendMessageBatchRequest.getEntries();
        int index = 0;
        for (SendMessageBatchRequestEntry entry : batchEntries) {
            this.checkMessageAttributes(entry.getMessageAttributes());
            if (this.clientConfiguration.isAlwaysThroughS3() || this.isLarge(entry)) {
                batchEntries.set(index, this.storeMessageInS3(entry));
            }
            ++index;
        }
        return super.sendMessageBatch(sendMessageBatchRequest);
    }

    @Override
    public SendMessageBatchResult sendMessageBatch(String queueUrl, List<SendMessageBatchRequestEntry> entries) {
        SendMessageBatchRequest sendMessageBatchRequest = new SendMessageBatchRequest(queueUrl, entries);
        return this.sendMessageBatch(sendMessageBatchRequest);
    }

    @Override
    public DeleteMessageBatchResult deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        if (deleteMessageBatchRequest == null) {
            String errorMessage = "deleteMessageBatchRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        deleteMessageBatchRequest.getRequestClientOptions().appendUserAgent(USER_AGENT_HEADER);
        if (!this.clientConfiguration.isPayloadSupportEnabled()) {
            return super.deleteMessageBatch(deleteMessageBatchRequest);
        }
        for (DeleteMessageBatchRequestEntry entry : deleteMessageBatchRequest.getEntries()) {
            String receiptHandle;
            String origReceiptHandle = receiptHandle = entry.getReceiptHandle();
            if (this.isS3ReceiptHandle(receiptHandle)) {
                origReceiptHandle = this.getOrigReceiptHandle(receiptHandle);
                if (this.clientConfiguration.doesCleanupS3Payload()) {
                    String messagePointer = this.getMessagePointerFromModifiedReceiptHandle(receiptHandle);
                    this.payloadStore.deleteOriginalPayload(messagePointer);
                }
            }
            entry.setReceiptHandle(origReceiptHandle);
        }
        return super.deleteMessageBatch(deleteMessageBatchRequest);
    }

    @Override
    public DeleteMessageBatchResult deleteMessageBatch(String queueUrl, List<DeleteMessageBatchRequestEntry> entries) {
        DeleteMessageBatchRequest deleteMessageBatchRequest = new DeleteMessageBatchRequest(queueUrl, entries);
        return this.deleteMessageBatch(deleteMessageBatchRequest);
    }

    @Override
    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(String queueUrl, List<ChangeMessageVisibilityBatchRequestEntry> entries) {
        ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest = new ChangeMessageVisibilityBatchRequest(queueUrl, entries);
        return this.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
    }

    @Override
    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws AmazonServiceException, AmazonClientException {
        for (ChangeMessageVisibilityBatchRequestEntry entry : changeMessageVisibilityBatchRequest.getEntries()) {
            if (!this.isS3ReceiptHandle(entry.getReceiptHandle())) continue;
            entry.setReceiptHandle(this.getOrigReceiptHandle(entry.getReceiptHandle()));
        }
        return this.amazonSqsToBeExtended.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
    }

    @Override
    public PurgeQueueResult purgeQueue(PurgeQueueRequest purgeQueueRequest) throws AmazonServiceException, AmazonClientException {
        LOG.warn((Object)"Calling purgeQueue deletes SQS messages without deleting their payload from S3.");
        if (purgeQueueRequest == null) {
            String errorMessage = "purgeQueueRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        purgeQueueRequest.getRequestClientOptions().appendUserAgent(USER_AGENT_HEADER);
        return super.purgeQueue(purgeQueueRequest);
    }

    private void checkMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        int msgAttributesSize = this.getMsgAttributesSize(messageAttributes);
        if (msgAttributesSize > this.clientConfiguration.getPayloadSizeThreshold()) {
            String errorMessage = "Total size of Message attributes is " + msgAttributesSize + " bytes which is larger than the threshold of " + this.clientConfiguration.getPayloadSizeThreshold() + " Bytes. Consider including the payload in the message body instead of message attributes.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        int messageAttributesNum = messageAttributes.size();
        if (messageAttributesNum > 9) {
            String errorMessage = "Number of message attributes [" + messageAttributesNum + "] exceeds the maximum allowed for large-payload messages [" + 9 + "].";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        Optional<String> largePayloadAttributeName = this.getReservedAttributeNameIfPresent(messageAttributes);
        if (largePayloadAttributeName.isPresent()) {
            String errorMessage = "Message attribute name " + largePayloadAttributeName.get() + " is reserved for use by SQS extended client.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
    }

    private String embedS3PointerInReceiptHandle(String receiptHandle, String pointer) {
        PayloadS3Pointer s3Pointer = PayloadS3Pointer.fromJson((String)pointer);
        String s3MsgBucketName = s3Pointer.getS3BucketName();
        String s3MsgKey = s3Pointer.getS3Key();
        String modifiedReceiptHandle = "-..s3BucketName..-" + s3MsgBucketName + "-..s3BucketName..-" + "-..s3Key..-" + s3MsgKey + "-..s3Key..-" + receiptHandle;
        return modifiedReceiptHandle;
    }

    private String getOrigReceiptHandle(String receiptHandle) {
        int secondOccurence = receiptHandle.indexOf("-..s3Key..-", receiptHandle.indexOf("-..s3Key..-") + 1);
        return receiptHandle.substring(secondOccurence + "-..s3Key..-".length());
    }

    private String getFromReceiptHandleByMarker(String receiptHandle, String marker) {
        int firstOccurence = receiptHandle.indexOf(marker);
        int secondOccurence = receiptHandle.indexOf(marker, firstOccurence + 1);
        return receiptHandle.substring(firstOccurence + marker.length(), secondOccurence);
    }

    private boolean isS3ReceiptHandle(String receiptHandle) {
        return receiptHandle.contains("-..s3BucketName..-") && receiptHandle.contains("-..s3Key..-");
    }

    private String getMessagePointerFromModifiedReceiptHandle(String receiptHandle) {
        String s3MsgBucketName = this.getFromReceiptHandleByMarker(receiptHandle, "-..s3BucketName..-");
        String s3MsgKey = this.getFromReceiptHandleByMarker(receiptHandle, "-..s3Key..-");
        PayloadS3Pointer payloadS3Pointer = new PayloadS3Pointer(s3MsgBucketName, s3MsgKey);
        return payloadS3Pointer.toJson();
    }

    private boolean isLarge(SendMessageRequest sendMessageRequest) {
        long msgBodySize;
        int msgAttributesSize = this.getMsgAttributesSize(sendMessageRequest.getMessageAttributes());
        long totalMsgSize = (long)msgAttributesSize + (msgBodySize = Util.getStringSizeInBytes((String)sendMessageRequest.getMessageBody()));
        return totalMsgSize > (long)this.clientConfiguration.getPayloadSizeThreshold();
    }

    private boolean isLarge(SendMessageBatchRequestEntry batchEntry) {
        long msgBodySize;
        int msgAttributesSize = this.getMsgAttributesSize(batchEntry.getMessageAttributes());
        long totalMsgSize = (long)msgAttributesSize + (msgBodySize = Util.getStringSizeInBytes((String)batchEntry.getMessageBody()));
        return totalMsgSize > (long)this.clientConfiguration.getPayloadSizeThreshold();
    }

    private Optional<String> getReservedAttributeNameIfPresent(Map<String, MessageAttributeValue> msgAttributes) {
        String reservedAttributeName = null;
        if (msgAttributes.containsKey("ExtendedPayloadSize")) {
            reservedAttributeName = "ExtendedPayloadSize";
        } else if (msgAttributes.containsKey(LEGACY_RESERVED_ATTRIBUTE_NAME)) {
            reservedAttributeName = LEGACY_RESERVED_ATTRIBUTE_NAME;
        }
        return Optional.ofNullable(reservedAttributeName);
    }

    private int getMsgAttributesSize(Map<String, MessageAttributeValue> msgAttributes) {
        int totalMsgAttributesSize = 0;
        for (Map.Entry<String, MessageAttributeValue> entry : msgAttributes.entrySet()) {
            ByteBuffer binaryVal;
            String stringVal;
            totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + Util.getStringSizeInBytes((String)entry.getKey()));
            MessageAttributeValue entryVal = entry.getValue();
            if (entryVal.getDataType() != null) {
                totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + Util.getStringSizeInBytes((String)entryVal.getDataType()));
            }
            if ((stringVal = entryVal.getStringValue()) != null) {
                totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + Util.getStringSizeInBytes((String)entryVal.getStringValue()));
            }
            if ((binaryVal = entryVal.getBinaryValue()) == null) continue;
            totalMsgAttributesSize += binaryVal.array().length;
        }
        return totalMsgAttributesSize;
    }

    private SendMessageBatchRequestEntry storeMessageInS3(SendMessageBatchRequestEntry batchEntry) {
        String messageContentStr = batchEntry.getMessageBody();
        Long messageContentSize = Util.getStringSizeInBytes((String)messageContentStr);
        MessageAttributeValue messageAttributeValue = new MessageAttributeValue();
        messageAttributeValue.setDataType("Number");
        messageAttributeValue.setStringValue(messageContentSize.toString());
        if (!this.clientConfiguration.usesLegacyReservedAttributeName()) {
            batchEntry.addMessageAttributesEntry("ExtendedPayloadSize", messageAttributeValue);
        } else {
            batchEntry.addMessageAttributesEntry(LEGACY_RESERVED_ATTRIBUTE_NAME, messageAttributeValue);
        }
        String largeMessagePointer = this.payloadStore.storeOriginalPayload(messageContentStr, messageContentSize);
        batchEntry.setMessageBody(largeMessagePointer);
        return batchEntry;
    }

    private SendMessageRequest storeMessageInS3(SendMessageRequest sendMessageRequest) {
        String messageContentStr = sendMessageRequest.getMessageBody();
        Long messageContentSize = Util.getStringSizeInBytes((String)messageContentStr);
        MessageAttributeValue messageAttributeValue = new MessageAttributeValue();
        messageAttributeValue.setDataType("Number");
        messageAttributeValue.setStringValue(messageContentSize.toString());
        if (!this.clientConfiguration.usesLegacyReservedAttributeName()) {
            sendMessageRequest.addMessageAttributesEntry("ExtendedPayloadSize", messageAttributeValue);
        } else {
            sendMessageRequest.addMessageAttributesEntry(LEGACY_RESERVED_ATTRIBUTE_NAME, messageAttributeValue);
        }
        String largeMessagePointer = this.payloadStore.storeOriginalPayload(messageContentStr, messageContentSize);
        sendMessageRequest.setMessageBody(largeMessagePointer);
        return sendMessageRequest;
    }
}

