/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

class JsonDataConverter {
    protected final ObjectMapper objectMapper;

    public JsonDataConverter() {
        this(new ObjectMapper());
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
    }

    public JsonDataConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String serializeToJson(Object obj) throws JsonProcessingException {
        ObjectWriter objectWriter = this.objectMapper.writer();
        return objectWriter.writeValueAsString(obj);
    }

    public <T> T deserializeFromJson(String jsonText, Class<T> objectType) throws Exception {
        return (T)this.objectMapper.readValue(jsonText, objectType);
    }
}

