/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.regions.Region;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.services.sqs.model.AddPermissionResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityResult;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.DeleteQueueResult;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesResult;
import com.amazonaws.services.sqs.model.ListQueueTagsRequest;
import com.amazonaws.services.sqs.model.ListQueueTagsResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.PurgeQueueResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.RemovePermissionRequest;
import com.amazonaws.services.sqs.model.RemovePermissionResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.SetQueueAttributesResult;
import com.amazonaws.services.sqs.model.TagQueueRequest;
import com.amazonaws.services.sqs.model.TagQueueResult;
import com.amazonaws.services.sqs.model.UntagQueueRequest;
import com.amazonaws.services.sqs.model.UntagQueueResult;
import java.util.List;
import java.util.Map;

abstract class AmazonSQSExtendedClientBase
implements AmazonSQS {
    AmazonSQS amazonSqsToBeExtended;

    public AmazonSQSExtendedClientBase(AmazonSQS sqsClient) {
        this.amazonSqsToBeExtended = sqsClient;
    }

    public SendMessageResult sendMessage(SendMessageRequest sendMessageRequest) {
        return this.amazonSqsToBeExtended.sendMessage(sendMessageRequest);
    }

    public ReceiveMessageResult receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        return this.amazonSqsToBeExtended.receiveMessage(receiveMessageRequest);
    }

    public DeleteMessageResult deleteMessage(DeleteMessageRequest deleteMessageRequest) {
        return this.amazonSqsToBeExtended.deleteMessage(deleteMessageRequest);
    }

    public SendMessageResult sendMessage(String queueUrl, String messageBody) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.sendMessage(queueUrl, messageBody);
    }

    public ReceiveMessageResult receiveMessage(String queueUrl) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.receiveMessage(queueUrl);
    }

    public DeleteMessageResult deleteMessage(String queueUrl, String receiptHandle) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.deleteMessage(queueUrl, receiptHandle);
    }

    public SetQueueAttributesResult setQueueAttributes(SetQueueAttributesRequest setQueueAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.setQueueAttributes(setQueueAttributesRequest);
    }

    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
    }

    public ChangeMessageVisibilityResult changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.changeMessageVisibility(changeMessageVisibilityRequest);
    }

    public GetQueueUrlResult getQueueUrl(GetQueueUrlRequest getQueueUrlRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.getQueueUrl(getQueueUrlRequest);
    }

    public RemovePermissionResult removePermission(RemovePermissionRequest removePermissionRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.removePermission(removePermissionRequest);
    }

    public GetQueueAttributesResult getQueueAttributes(GetQueueAttributesRequest getQueueAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.getQueueAttributes(getQueueAttributesRequest);
    }

    public SendMessageBatchResult sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.sendMessageBatch(sendMessageBatchRequest);
    }

    public PurgeQueueResult purgeQueue(PurgeQueueRequest purgeQueueRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.purgeQueue(purgeQueueRequest);
    }

    public ListDeadLetterSourceQueuesResult listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.listDeadLetterSourceQueues(listDeadLetterSourceQueuesRequest);
    }

    public DeleteQueueResult deleteQueue(DeleteQueueRequest deleteQueueRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.deleteQueue(deleteQueueRequest);
    }

    public ListQueuesResult listQueues(ListQueuesRequest listQueuesRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.listQueues(listQueuesRequest);
    }

    public DeleteMessageBatchResult deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.deleteMessageBatch(deleteMessageBatchRequest);
    }

    public CreateQueueResult createQueue(CreateQueueRequest createQueueRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.createQueue(createQueueRequest);
    }

    public AddPermissionResult addPermission(AddPermissionRequest addPermissionRequest) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.addPermission(addPermissionRequest);
    }

    public ListQueuesResult listQueues() throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.listQueues();
    }

    public SetQueueAttributesResult setQueueAttributes(String queueUrl, Map<String, String> attributes) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.setQueueAttributes(queueUrl, attributes);
    }

    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(String queueUrl, List<ChangeMessageVisibilityBatchRequestEntry> entries) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.changeMessageVisibilityBatch(queueUrl, entries);
    }

    public ChangeMessageVisibilityResult changeMessageVisibility(String queueUrl, String receiptHandle, Integer visibilityTimeout) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.changeMessageVisibility(queueUrl, receiptHandle, visibilityTimeout);
    }

    public GetQueueUrlResult getQueueUrl(String queueName) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.getQueueUrl(queueName);
    }

    public RemovePermissionResult removePermission(String queueUrl, String label) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.removePermission(queueUrl, label);
    }

    public GetQueueAttributesResult getQueueAttributes(String queueUrl, List<String> attributeNames) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.getQueueAttributes(queueUrl, attributeNames);
    }

    public SendMessageBatchResult sendMessageBatch(String queueUrl, List<SendMessageBatchRequestEntry> entries) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.sendMessageBatch(queueUrl, entries);
    }

    public DeleteQueueResult deleteQueue(String queueUrl) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.deleteQueue(queueUrl);
    }

    public ListQueuesResult listQueues(String queueNamePrefix) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.listQueues(queueNamePrefix);
    }

    public DeleteMessageBatchResult deleteMessageBatch(String queueUrl, List<DeleteMessageBatchRequestEntry> entries) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.deleteMessageBatch(queueUrl, entries);
    }

    public CreateQueueResult createQueue(String queueName) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.createQueue(queueName);
    }

    public AddPermissionResult addPermission(String queueUrl, String label, List<String> aWSAccountIds, List<String> actions) throws AmazonServiceException, AmazonClientException {
        return this.amazonSqsToBeExtended.addPermission(queueUrl, label, aWSAccountIds, actions);
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.amazonSqsToBeExtended.getCachedResponseMetadata(request);
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        this.amazonSqsToBeExtended.setEndpoint(endpoint);
    }

    public void setRegion(Region region) throws IllegalArgumentException {
        this.amazonSqsToBeExtended.setRegion(region);
    }

    public void shutdown() {
        this.amazonSqsToBeExtended.shutdown();
    }

    public ListQueueTagsResult listQueueTags(ListQueueTagsRequest listQueueTagsRequest) {
        return this.amazonSqsToBeExtended.listQueueTags(listQueueTagsRequest);
    }

    public ListQueueTagsResult listQueueTags(String queueUrl) {
        return this.amazonSqsToBeExtended.listQueueTags(queueUrl);
    }

    public TagQueueResult tagQueue(TagQueueRequest tagQueueRequest) {
        return this.amazonSqsToBeExtended.tagQueue(tagQueueRequest);
    }

    public TagQueueResult tagQueue(String queueUrl, Map<String, String> tags) {
        return this.amazonSqsToBeExtended.tagQueue(queueUrl, tags);
    }

    public UntagQueueResult untagQueue(UntagQueueRequest untagQueueRequest) {
        return this.amazonSqsToBeExtended.untagQueue(untagQueueRequest);
    }

    public UntagQueueResult untagQueue(String queueUrl, List<String> tagKeys) {
        return this.amazonSqsToBeExtended.untagQueue(queueUrl, tagKeys);
    }
}

