/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.AmazonSQSExtendedClientBase;
import com.amazon.sqs.javamessaging.CountingOutputStream;
import com.amazon.sqs.javamessaging.ExtendedClientConfiguration;
import com.amazon.sqs.javamessaging.JsonDataConverter;
import com.amazon.sqs.javamessaging.MessageS3Pointer;
import com.amazon.sqs.javamessaging.SQSExtendedClientConstants;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.PurgeQueueResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonSQSExtendedClient
extends AmazonSQSExtendedClientBase
implements AmazonSQS {
    private static final Log LOG = LogFactory.getLog(AmazonSQSExtendedClient.class);
    private ExtendedClientConfiguration clientConfiguration;

    public AmazonSQSExtendedClient(AmazonSQS sqsClient) {
        this(sqsClient, new ExtendedClientConfiguration());
    }

    public AmazonSQSExtendedClient(AmazonSQS sqsClient, ExtendedClientConfiguration extendedClientConfig) {
        super(sqsClient);
        this.clientConfiguration = new ExtendedClientConfiguration(extendedClientConfig);
    }

    @Override
    public SendMessageResult sendMessage(SendMessageRequest sendMessageRequest) {
        if (sendMessageRequest == null) {
            String errorMessage = "sendMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        sendMessageRequest.getRequestClientOptions().appendUserAgent(SQSExtendedClientConstants.USER_AGENT_HEADER);
        if (!this.clientConfiguration.isLargePayloadSupportEnabled()) {
            return super.sendMessage(sendMessageRequest);
        }
        if (sendMessageRequest.getMessageBody() == null || "".equals(sendMessageRequest.getMessageBody())) {
            String errorMessage = "messageBody cannot be null or empty.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        if (this.clientConfiguration.isAlwaysThroughS3() || this.isLarge(sendMessageRequest)) {
            sendMessageRequest = this.storeMessageInS3(sendMessageRequest);
        }
        return super.sendMessage(sendMessageRequest);
    }

    @Override
    public SendMessageResult sendMessage(String queueUrl, String messageBody) {
        SendMessageRequest sendMessageRequest = new SendMessageRequest(queueUrl, messageBody);
        return this.sendMessage(sendMessageRequest);
    }

    @Override
    public ReceiveMessageResult receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        if (receiveMessageRequest == null) {
            String errorMessage = "receiveMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        receiveMessageRequest.getRequestClientOptions().appendUserAgent(SQSExtendedClientConstants.USER_AGENT_HEADER);
        if (!this.clientConfiguration.isLargePayloadSupportEnabled()) {
            return super.receiveMessage(receiveMessageRequest);
        }
        receiveMessageRequest.getMessageAttributeNames().add("SQSLargePayloadSize");
        ReceiveMessageResult receiveMessageResult = super.receiveMessage(receiveMessageRequest);
        List messages = receiveMessageResult.getMessages();
        for (Message message : messages) {
            MessageAttributeValue largePayloadAttributeValue = (MessageAttributeValue)message.getMessageAttributes().get("SQSLargePayloadSize");
            if (largePayloadAttributeValue == null) continue;
            String messageBody = message.getBody();
            MessageS3Pointer s3Pointer = this.readMessageS3PointerFromJSON(messageBody);
            String s3MsgBucketName = s3Pointer.getS3BucketName();
            String s3MsgKey = s3Pointer.getS3Key();
            String origMsgBody = this.getTextFromS3(s3MsgBucketName, s3MsgKey);
            LOG.info((Object)("S3 object read, Bucket name: " + s3MsgBucketName + ", Object key: " + s3MsgKey + "."));
            message.setBody(origMsgBody);
            message.getMessageAttributes().remove("SQSLargePayloadSize");
            String modifiedReceiptHandle = this.embedS3PointerInReceiptHandle(message.getReceiptHandle(), s3MsgBucketName, s3MsgKey);
            message.setReceiptHandle(modifiedReceiptHandle);
        }
        return receiveMessageResult;
    }

    @Override
    public ReceiveMessageResult receiveMessage(String queueUrl) {
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(queueUrl);
        return this.receiveMessage(receiveMessageRequest);
    }

    @Override
    public DeleteMessageResult deleteMessage(DeleteMessageRequest deleteMessageRequest) {
        String receiptHandle;
        if (deleteMessageRequest == null) {
            String errorMessage = "deleteMessageRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        deleteMessageRequest.getRequestClientOptions().appendUserAgent(SQSExtendedClientConstants.USER_AGENT_HEADER);
        if (!this.clientConfiguration.isLargePayloadSupportEnabled()) {
            return super.deleteMessage(deleteMessageRequest);
        }
        String origReceiptHandle = receiptHandle = deleteMessageRequest.getReceiptHandle();
        if (this.isS3ReceiptHandle(receiptHandle)) {
            this.deleteMessagePayloadFromS3(receiptHandle);
            origReceiptHandle = this.getOrigReceiptHandle(receiptHandle);
        }
        deleteMessageRequest.setReceiptHandle(origReceiptHandle);
        return super.deleteMessage(deleteMessageRequest);
    }

    @Override
    public DeleteMessageResult deleteMessage(String queueUrl, String receiptHandle) {
        DeleteMessageRequest deleteMessageRequest = new DeleteMessageRequest(queueUrl, receiptHandle);
        return this.deleteMessage(deleteMessageRequest);
    }

    @Override
    public ChangeMessageVisibilityResult changeMessageVisibility(String queueUrl, String receiptHandle, Integer visibilityTimeout) {
        ChangeMessageVisibilityRequest changeMessageVisibilityRequest = new ChangeMessageVisibilityRequest(queueUrl, receiptHandle, visibilityTimeout);
        return this.changeMessageVisibility(changeMessageVisibilityRequest);
    }

    @Override
    public ChangeMessageVisibilityResult changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws AmazonServiceException, AmazonClientException {
        if (this.isS3ReceiptHandle(changeMessageVisibilityRequest.getReceiptHandle())) {
            changeMessageVisibilityRequest.setReceiptHandle(this.getOrigReceiptHandle(changeMessageVisibilityRequest.getReceiptHandle()));
        }
        return this.amazonSqsToBeExtended.changeMessageVisibility(changeMessageVisibilityRequest);
    }

    @Override
    public SendMessageBatchResult sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) {
        if (sendMessageBatchRequest == null) {
            String errorMessage = "sendMessageBatchRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        sendMessageBatchRequest.getRequestClientOptions().appendUserAgent(SQSExtendedClientConstants.USER_AGENT_HEADER);
        if (!this.clientConfiguration.isLargePayloadSupportEnabled()) {
            return super.sendMessageBatch(sendMessageBatchRequest);
        }
        List batchEntries = sendMessageBatchRequest.getEntries();
        int index = 0;
        for (SendMessageBatchRequestEntry entry : batchEntries) {
            if (this.clientConfiguration.isAlwaysThroughS3() || this.isLarge(entry)) {
                batchEntries.set(index, this.storeMessageInS3(entry));
            }
            ++index;
        }
        return super.sendMessageBatch(sendMessageBatchRequest);
    }

    @Override
    public SendMessageBatchResult sendMessageBatch(String queueUrl, List<SendMessageBatchRequestEntry> entries) {
        SendMessageBatchRequest sendMessageBatchRequest = new SendMessageBatchRequest(queueUrl, entries);
        return this.sendMessageBatch(sendMessageBatchRequest);
    }

    @Override
    public DeleteMessageBatchResult deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        if (deleteMessageBatchRequest == null) {
            String errorMessage = "deleteMessageBatchRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        deleteMessageBatchRequest.getRequestClientOptions().appendUserAgent(SQSExtendedClientConstants.USER_AGENT_HEADER);
        if (!this.clientConfiguration.isLargePayloadSupportEnabled()) {
            return super.deleteMessageBatch(deleteMessageBatchRequest);
        }
        for (DeleteMessageBatchRequestEntry entry : deleteMessageBatchRequest.getEntries()) {
            String receiptHandle;
            String origReceiptHandle = receiptHandle = entry.getReceiptHandle();
            if (this.isS3ReceiptHandle(receiptHandle)) {
                this.deleteMessagePayloadFromS3(receiptHandle);
                origReceiptHandle = this.getOrigReceiptHandle(receiptHandle);
            }
            entry.setReceiptHandle(origReceiptHandle);
        }
        return super.deleteMessageBatch(deleteMessageBatchRequest);
    }

    @Override
    public DeleteMessageBatchResult deleteMessageBatch(String queueUrl, List<DeleteMessageBatchRequestEntry> entries) {
        DeleteMessageBatchRequest deleteMessageBatchRequest = new DeleteMessageBatchRequest(queueUrl, entries);
        return this.deleteMessageBatch(deleteMessageBatchRequest);
    }

    @Override
    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(String queueUrl, List<ChangeMessageVisibilityBatchRequestEntry> entries) {
        ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest = new ChangeMessageVisibilityBatchRequest(queueUrl, entries);
        return this.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
    }

    @Override
    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws AmazonServiceException, AmazonClientException {
        for (ChangeMessageVisibilityBatchRequestEntry entry : changeMessageVisibilityBatchRequest.getEntries()) {
            if (!this.isS3ReceiptHandle(entry.getReceiptHandle())) continue;
            entry.setReceiptHandle(this.getOrigReceiptHandle(entry.getReceiptHandle()));
        }
        return this.amazonSqsToBeExtended.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
    }

    @Override
    public PurgeQueueResult purgeQueue(PurgeQueueRequest purgeQueueRequest) throws AmazonServiceException, AmazonClientException {
        LOG.warn((Object)"Calling purgeQueue deletes SQS messages without deleting their payload from S3.");
        if (purgeQueueRequest == null) {
            String errorMessage = "purgeQueueRequest cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        purgeQueueRequest.getRequestClientOptions().appendUserAgent(SQSExtendedClientConstants.USER_AGENT_HEADER);
        return super.purgeQueue(purgeQueueRequest);
    }

    private void deleteMessagePayloadFromS3(String receiptHandle) {
        String s3MsgBucketName = this.getFromReceiptHandleByMarker(receiptHandle, "-..s3BucketName..-");
        String s3MsgKey = this.getFromReceiptHandleByMarker(receiptHandle, "-..s3Key..-");
        try {
            this.clientConfiguration.getAmazonS3Client().deleteObject(s3MsgBucketName, s3MsgKey);
        }
        catch (AmazonServiceException e) {
            String errorMessage = "Failed to delete the S3 object which contains the SQS message payload. SQS message was not deleted.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonServiceException(errorMessage, (Exception)((Object)e));
        }
        catch (AmazonClientException e) {
            String errorMessage = "Failed to delete the S3 object which contains the SQS message payload. SQS message was not deleted.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
        LOG.info((Object)("S3 object deleted, Bucket name: " + s3MsgBucketName + ", Object key: " + s3MsgKey + "."));
    }

    private void checkMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        int msgAttributesSize = this.getMsgAttributesSize(messageAttributes);
        if (msgAttributesSize > this.clientConfiguration.getMessageSizeThreshold()) {
            String errorMessage = "Total size of Message attributes is " + msgAttributesSize + " bytes which is larger than the threshold of " + this.clientConfiguration.getMessageSizeThreshold() + " Bytes. Consider including the payload in the message body instead of message attributes.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        int messageAttributesNum = messageAttributes.size();
        if (messageAttributesNum > 9) {
            String errorMessage = "Number of message attributes [" + messageAttributesNum + "] exceeds the maximum allowed for large-payload messages [" + 9 + "].";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        MessageAttributeValue largePayloadAttributeValue = messageAttributes.get("SQSLargePayloadSize");
        if (largePayloadAttributeValue != null) {
            String errorMessage = "Message attribute name SQSLargePayloadSize is reserved for use by SQS extended client.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
    }

    private String embedS3PointerInReceiptHandle(String receiptHandle, String s3MsgBucketName, String s3MsgKey) {
        String modifiedReceiptHandle = "-..s3BucketName..-" + s3MsgBucketName + "-..s3BucketName..-" + "-..s3Key..-" + s3MsgKey + "-..s3Key..-" + receiptHandle;
        return modifiedReceiptHandle;
    }

    private MessageS3Pointer readMessageS3PointerFromJSON(String messageBody) {
        MessageS3Pointer s3Pointer = null;
        try {
            JsonDataConverter jsonDataConverter = new JsonDataConverter();
            s3Pointer = jsonDataConverter.deserializeFromJson(messageBody, MessageS3Pointer.class);
        }
        catch (Exception e) {
            String errorMessage = "Failed to read the S3 object pointer from an SQS message. Message was not received.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
        return s3Pointer;
    }

    private String getOrigReceiptHandle(String receiptHandle) {
        int secondOccurence = receiptHandle.indexOf("-..s3Key..-", receiptHandle.indexOf("-..s3Key..-") + 1);
        return receiptHandle.substring(secondOccurence + "-..s3Key..-".length());
    }

    private String getFromReceiptHandleByMarker(String receiptHandle, String marker) {
        int firstOccurence = receiptHandle.indexOf(marker);
        int secondOccurence = receiptHandle.indexOf(marker, firstOccurence + 1);
        return receiptHandle.substring(firstOccurence + marker.length(), secondOccurence);
    }

    private boolean isS3ReceiptHandle(String receiptHandle) {
        return receiptHandle.contains("-..s3BucketName..-") && receiptHandle.contains("-..s3Key..-");
    }

    private String getTextFromS3(String s3BucketName, String s3Key) {
        GetObjectRequest getObjectRequest = new GetObjectRequest(s3BucketName, s3Key);
        String embeddedText = null;
        S3Object obj = null;
        try {
            obj = this.clientConfiguration.getAmazonS3Client().getObject(getObjectRequest);
        }
        catch (AmazonServiceException e) {
            String errorMessage = "Failed to get the S3 object which contains the message payload. Message was not received.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonServiceException(errorMessage, (Exception)((Object)e));
        }
        catch (AmazonClientException e) {
            String errorMessage = "Failed to get the S3 object which contains the message payload. Message was not received.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
        S3ObjectInputStream is = obj.getObjectContent();
        try {
            embeddedText = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            String errorMessage = "Failure when handling the message which was read from S3 object. Message was not received.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)is, (Log)LOG);
        }
        return embeddedText;
    }

    private boolean isLarge(SendMessageRequest sendMessageRequest) {
        long msgBodySize;
        int msgAttributesSize = this.getMsgAttributesSize(sendMessageRequest.getMessageAttributes());
        long totalMsgSize = (long)msgAttributesSize + (msgBodySize = AmazonSQSExtendedClient.getStringSizeInBytes(sendMessageRequest.getMessageBody()));
        return totalMsgSize > (long)this.clientConfiguration.getMessageSizeThreshold();
    }

    private boolean isLarge(SendMessageBatchRequestEntry batchEntry) {
        long msgBodySize;
        int msgAttributesSize = this.getMsgAttributesSize(batchEntry.getMessageAttributes());
        long totalMsgSize = (long)msgAttributesSize + (msgBodySize = AmazonSQSExtendedClient.getStringSizeInBytes(batchEntry.getMessageBody()));
        return totalMsgSize > (long)this.clientConfiguration.getMessageSizeThreshold();
    }

    private int getMsgAttributesSize(Map<String, MessageAttributeValue> msgAttributes) {
        int totalMsgAttributesSize = 0;
        for (Map.Entry<String, MessageAttributeValue> entry : msgAttributes.entrySet()) {
            ByteBuffer binaryVal;
            String stringVal;
            totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + AmazonSQSExtendedClient.getStringSizeInBytes(entry.getKey()));
            MessageAttributeValue entryVal = entry.getValue();
            if (entryVal.getDataType() != null) {
                totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + AmazonSQSExtendedClient.getStringSizeInBytes(entryVal.getDataType()));
            }
            if ((stringVal = entryVal.getStringValue()) != null) {
                totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + AmazonSQSExtendedClient.getStringSizeInBytes(entryVal.getStringValue()));
            }
            if ((binaryVal = entryVal.getBinaryValue()) == null) continue;
            totalMsgAttributesSize += binaryVal.array().length;
        }
        return totalMsgAttributesSize;
    }

    private SendMessageBatchRequestEntry storeMessageInS3(SendMessageBatchRequestEntry batchEntry) {
        this.checkMessageAttributes(batchEntry.getMessageAttributes());
        String s3Key = UUID.randomUUID().toString();
        String messageContentStr = batchEntry.getMessageBody();
        Long messageContentSize = AmazonSQSExtendedClient.getStringSizeInBytes(messageContentStr);
        MessageAttributeValue messageAttributeValue = new MessageAttributeValue();
        messageAttributeValue.setDataType("Number");
        messageAttributeValue.setStringValue(messageContentSize.toString());
        batchEntry.addMessageAttributesEntry("SQSLargePayloadSize", messageAttributeValue);
        this.storeTextInS3(s3Key, messageContentStr, messageContentSize);
        LOG.info((Object)("S3 object created, Bucket name: " + this.clientConfiguration.getS3BucketName() + ", Object key: " + s3Key + "."));
        MessageS3Pointer s3Pointer = new MessageS3Pointer(this.clientConfiguration.getS3BucketName(), s3Key);
        String s3PointerStr = this.getJSONFromS3Pointer(s3Pointer);
        batchEntry.setMessageBody(s3PointerStr);
        return batchEntry;
    }

    private SendMessageRequest storeMessageInS3(SendMessageRequest sendMessageRequest) {
        this.checkMessageAttributes(sendMessageRequest.getMessageAttributes());
        String s3Key = UUID.randomUUID().toString();
        String messageContentStr = sendMessageRequest.getMessageBody();
        Long messageContentSize = AmazonSQSExtendedClient.getStringSizeInBytes(messageContentStr);
        MessageAttributeValue messageAttributeValue = new MessageAttributeValue();
        messageAttributeValue.setDataType("Number");
        messageAttributeValue.setStringValue(messageContentSize.toString());
        sendMessageRequest.addMessageAttributesEntry("SQSLargePayloadSize", messageAttributeValue);
        this.storeTextInS3(s3Key, messageContentStr, messageContentSize);
        LOG.info((Object)("S3 object created, Bucket name: " + this.clientConfiguration.getS3BucketName() + ", Object key: " + s3Key + "."));
        MessageS3Pointer s3Pointer = new MessageS3Pointer(this.clientConfiguration.getS3BucketName(), s3Key);
        String s3PointerStr = this.getJSONFromS3Pointer(s3Pointer);
        sendMessageRequest.setMessageBody(s3PointerStr);
        return sendMessageRequest;
    }

    private String getJSONFromS3Pointer(MessageS3Pointer s3Pointer) {
        String s3PointerStr = null;
        try {
            JsonDataConverter jsonDataConverter = new JsonDataConverter();
            s3PointerStr = jsonDataConverter.serializeToJson(s3Pointer);
        }
        catch (Exception e) {
            String errorMessage = "Failed to convert S3 object pointer to text. Message was not sent.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
        return s3PointerStr;
    }

    private void storeTextInS3(String s3Key, String messageContentStr, Long messageContentSize) {
        ByteArrayInputStream messageContentStream = new ByteArrayInputStream(messageContentStr.getBytes(StandardCharsets.UTF_8));
        ObjectMetadata messageContentStreamMetadata = new ObjectMetadata();
        messageContentStreamMetadata.setContentLength(messageContentSize.longValue());
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.clientConfiguration.getS3BucketName(), s3Key, (InputStream)messageContentStream, messageContentStreamMetadata);
        try {
            this.clientConfiguration.getAmazonS3Client().putObject(putObjectRequest);
        }
        catch (AmazonServiceException e) {
            String errorMessage = "Failed to store the message content in an S3 object. SQS message was not sent.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonServiceException(errorMessage, (Exception)((Object)e));
        }
        catch (AmazonClientException e) {
            String errorMessage = "Failed to store the message content in an S3 object. SQS message was not sent.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
    }

    private static long getStringSizeInBytes(String str) {
        CountingOutputStream counterOutputStream = new CountingOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)counterOutputStream, "UTF-8");
            writer.write(str);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            String errorMessage = "Failed to calculate the size of message payload.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
        return counterOutputStream.getTotalSize();
    }
}

