/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public class ExtendedClientConfiguration {
    private static final Log LOG = LogFactory.getLog(ExtendedClientConfiguration.class);
    private AmazonS3 s3;
    private String s3BucketName;
    private boolean largePayloadSupport = false;
    private boolean alwaysThroughS3 = false;
    private int messageSizeThreshold = 262144;

    public ExtendedClientConfiguration() {
        this.s3 = null;
        this.s3BucketName = null;
    }

    public ExtendedClientConfiguration(ExtendedClientConfiguration other) {
        this.s3 = other.s3;
        this.s3BucketName = other.s3BucketName;
        this.largePayloadSupport = other.largePayloadSupport;
        this.alwaysThroughS3 = other.alwaysThroughS3;
        this.messageSizeThreshold = other.messageSizeThreshold;
    }

    public void setLargePayloadSupportEnabled(AmazonS3 s3, String s3BucketName) {
        if (s3 == null || s3BucketName == null) {
            String errorMessage = "S3 client and/or S3 bucket name cannot be null.";
            LOG.error((Object)errorMessage);
            throw new AmazonClientException(errorMessage);
        }
        if (this.isLargePayloadSupportEnabled()) {
            LOG.warn((Object)"Large-payload support is already enabled. Overwriting AmazonS3Client and S3BucketName.");
        }
        this.s3 = s3;
        this.s3BucketName = s3BucketName;
        this.largePayloadSupport = true;
        LOG.info((Object)"Large-payload support enabled.");
    }

    public ExtendedClientConfiguration withLargePayloadSupportEnabled(AmazonS3 s3, String s3BucketName) {
        this.setLargePayloadSupportEnabled(s3, s3BucketName);
        return this;
    }

    public void setLargePayloadSupportDisabled() {
        this.s3 = null;
        this.s3BucketName = null;
        this.largePayloadSupport = false;
        LOG.info((Object)"Large-payload support disabled.");
    }

    public ExtendedClientConfiguration withLargePayloadSupportDisabled() {
        this.setLargePayloadSupportDisabled();
        return this;
    }

    public boolean isLargePayloadSupportEnabled() {
        return this.largePayloadSupport;
    }

    public AmazonS3 getAmazonS3Client() {
        return this.s3;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public void setMessageSizeThreshold(int messageSizeThreshold) {
        this.messageSizeThreshold = messageSizeThreshold;
    }

    public ExtendedClientConfiguration withMessageSizeThreshold(int messageSizeThreshold) {
        this.setMessageSizeThreshold(messageSizeThreshold);
        return this;
    }

    public int getMessageSizeThreshold() {
        return this.messageSizeThreshold;
    }

    public void setAlwaysThroughS3(boolean alwaysThroughS3) {
        this.alwaysThroughS3 = alwaysThroughS3;
    }

    public ExtendedClientConfiguration withAlwaysThroughS3(boolean alwaysThroughS3) {
        this.setAlwaysThroughS3(alwaysThroughS3);
        return this;
    }

    public boolean isAlwaysThroughS3() {
        return this.alwaysThroughS3;
    }
}

