/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.connectors.s3;

import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.connectors.KinesisConnectorConfiguration;
import com.amazonaws.services.kinesis.connectors.UnmodifiableBuffer;
import com.amazonaws.services.kinesis.connectors.s3.S3Emitter;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3ManifestEmitter
extends S3Emitter {
    private static final Log LOG = LogFactory.getLog(S3ManifestEmitter.class);
    private final AmazonKinesisClient kinesisClient;
    private final String manifestStream;

    public S3ManifestEmitter(KinesisConnectorConfiguration configuration) {
        super(configuration);
        this.manifestStream = configuration.KINESIS_OUTPUT_STREAM;
        this.kinesisClient = new AmazonKinesisClient(configuration.AWS_CREDENTIALS_PROVIDER);
        if (configuration.KINESIS_ENDPOINT != null) {
            this.kinesisClient.setEndpoint(configuration.KINESIS_ENDPOINT);
        }
    }

    @Override
    public List<byte[]> emit(UnmodifiableBuffer<byte[]> buffer) throws IOException {
        List<byte[]> failed = super.emit(buffer);
        if (!failed.isEmpty()) {
            return buffer.getRecords();
        }
        String s3File = this.getS3FileName(buffer.getFirstSequenceNumber(), buffer.getLastSequenceNumber());
        ByteBuffer data = ByteBuffer.wrap(s3File.getBytes());
        PutRecordRequest putRecordRequest = new PutRecordRequest();
        putRecordRequest.setData(data);
        putRecordRequest.setStreamName(this.manifestStream);
        putRecordRequest.setPartitionKey(this.manifestStream);
        try {
            this.kinesisClient.putRecord(putRecordRequest);
            LOG.info((Object)("S3ManifestEmitter emitted record downstream: " + s3File));
            return Collections.emptyList();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return buffer.getRecords();
        }
    }

    @Override
    public void fail(List<byte[]> records) {
        super.fail(records);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.kinesisClient.shutdown();
    }
}

