/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.connectors.redshift;

import com.amazonaws.services.kinesis.connectors.KinesisConnectorConfiguration;
import com.amazonaws.services.kinesis.connectors.UnmodifiableBuffer;
import com.amazonaws.services.kinesis.connectors.s3.S3Emitter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RedshiftBasicEmitter
extends S3Emitter {
    private static final Log LOG = LogFactory.getLog(RedshiftBasicEmitter.class);
    private final String s3bucket;
    private final String redshiftTable;
    private final String redshiftURL;
    private final char redshiftDelimiter;
    private final Properties loginProperties;
    private final String accessKey;
    private final String secretKey;

    public RedshiftBasicEmitter(KinesisConnectorConfiguration configuration) {
        super(configuration);
        this.s3bucket = configuration.S3_BUCKET;
        this.redshiftTable = configuration.REDSHIFT_DATA_TABLE;
        this.redshiftDelimiter = configuration.REDSHIFT_DATA_DELIMITER.charValue();
        this.redshiftURL = configuration.REDSHIFT_URL;
        this.loginProperties = new Properties();
        this.loginProperties.setProperty("user", configuration.REDSHIFT_USERNAME);
        this.loginProperties.setProperty("password", configuration.REDSHIFT_PASSWORD);
        this.accessKey = configuration.AWS_CREDENTIALS_PROVIDER.getCredentials().getAWSAccessKeyId();
        this.secretKey = configuration.AWS_CREDENTIALS_PROVIDER.getCredentials().getAWSSecretKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> emit(UnmodifiableBuffer<byte[]> buffer) throws IOException {
        List<byte[]> failed = super.emit(buffer);
        if (!failed.isEmpty()) {
            return buffer.getRecords();
        }
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(this.redshiftURL, this.loginProperties);
            String s3File = this.getS3FileName(buffer.getFirstSequenceNumber(), buffer.getLastSequenceNumber());
            this.executeStatement(this.generateCopyStatement(s3File), conn);
            LOG.info((Object)("Successfully copied " + this.getNumberOfCopiedRecords(conn) + " records to Amazon Redshift from file s3://" + this.s3Bucket + "/" + s3File));
            List<byte[]> list = Collections.emptyList();
            this.closeConnection(conn);
            return list;
        }
        catch (Exception e) {
            try {
                LOG.error((Object)e);
                List<byte[]> list = buffer.getRecords();
                this.closeConnection(conn);
                return list;
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
        }
    }

    @Override
    public void fail(List<byte[]> records) {
        super.fail(records);
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    private void closeConnection(Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    protected String generateCopyStatement(String s3File) {
        StringBuilder exec = new StringBuilder();
        exec.append("COPY " + this.redshiftTable + " ");
        exec.append("FROM 's3://" + this.s3bucket + "/" + s3File + "' ");
        exec.append("CREDENTIALS 'aws_access_key_id=" + this.accessKey);
        exec.append(";aws_secret_access_key=" + this.secretKey + "' ");
        exec.append("DELIMITER '" + this.redshiftDelimiter + "'");
        exec.append(";");
        return exec.toString();
    }

    private void executeStatement(String statement, Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            stmt.execute(statement);
        }
    }

    /*
     * Exception decompiling
     */
    private int getNumberOfCopiedRecords(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

